/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.org.antlr.codegen;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openksavi.sponge.jython.shaded.org.antlr.Tool;
import org.openksavi.sponge.jython.shaded.org.antlr.codegen.CodeGenerator;
import org.openksavi.sponge.jython.shaded.org.antlr.codegen.Target;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Grammar;
import org.openksavi.sponge.jython.shaded.org.stringtemplate.v4.AttributeRenderer;
import org.openksavi.sponge.jython.shaded.org.stringtemplate.v4.ST;
import org.openksavi.sponge.jython.shaded.org.stringtemplate.v4.STGroup;

public class RubyTarget
extends Target {
    public static final Set<String> rubyKeywords = new HashSet<String>(){
        {
            this.add("alias");
            this.add("END");
            this.add("retry");
            this.add("and");
            this.add("ensure");
            this.add("return");
            this.add("BEGIN");
            this.add("false");
            this.add("self");
            this.add("begin");
            this.add("for");
            this.add("super");
            this.add("break");
            this.add("if");
            this.add("then");
            this.add("case");
            this.add("in");
            this.add("true");
            this.add("class");
            this.add("module");
            this.add("undef");
            this.add("def");
            this.add("next");
            this.add("unless");
            this.add("defined?");
            this.add("nil");
            this.add("until");
            this.add("do");
            this.add("not");
            this.add("when");
            this.add("else");
            this.add("or");
            this.add("while");
            this.add("elsif");
            this.add("redo");
            this.add("yield");
            this.add("end");
            this.add("rescue");
        }
    };
    public static Map<String, Map<String, Object>> sharedActionBlocks = new HashMap<String, Map<String, Object>>();

    protected void genRecognizerFile(Tool tool2, CodeGenerator generator2, Grammar grammar2, ST outputFileST) throws IOException {
        Map<String, Map<String, Object>> actions;
        if (grammar2.type == 4) {
            actions = grammar2.getActions();
            if (actions.containsKey("all")) {
                sharedActionBlocks.put(grammar2.name, actions.get("all"));
            }
        } else if (grammar2.implicitLexer && sharedActionBlocks.containsKey(grammar2.name)) {
            actions = grammar2.getActions();
            actions.put("all", sharedActionBlocks.get(grammar2.name));
        }
        STGroup group = generator2.getTemplates();
        RubyRenderer renderer = new RubyRenderer();
        try {
            group.registerRenderer(Class.forName("java.lang.String"), renderer);
        }
        catch (ClassNotFoundException e) {
            System.err.println("ClassNotFoundException: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        String fileName = generator2.getRecognizerFileName(grammar2.name, grammar2.type);
        generator2.write(outputFileST, fileName);
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator2, String literal) {
        int code_point = 0;
        if ((literal = literal.substring(1, literal.length() - 1)).charAt(0) == '\\') {
            switch (literal.charAt(1)) {
                case '\"': 
                case '\'': 
                case '\\': {
                    code_point = literal.codePointAt(1);
                    break;
                }
                case 'n': {
                    code_point = 10;
                    break;
                }
                case 'r': {
                    code_point = 13;
                    break;
                }
                case 't': {
                    code_point = 9;
                    break;
                }
                case 'b': {
                    code_point = 8;
                    break;
                }
                case 'f': {
                    code_point = 12;
                    break;
                }
                case 'u': {
                    code_point = Integer.parseInt(literal.substring(2), 16);
                    break;
                }
                default: {
                    System.out.println("1: hey you didn't account for this: \"" + literal + "\"");
                    break;
                }
            }
        } else if (literal.length() == 1) {
            code_point = literal.codePointAt(0);
        } else {
            System.out.println("2: hey you didn't account for this: \"" + literal + "\"");
        }
        return "0x" + Integer.toHexString(code_point);
    }

    public int getMaxCharValue(CodeGenerator generator2) {
        return 255;
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator generator2, int ttype) {
        String name = generator2.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return generator2.grammar.computeTokenNameFromLiteral(ttype, name);
        }
        return name;
    }

    public boolean isValidActionScope(int grammarType, String scope) {
        if (scope.equals("all")) {
            return true;
        }
        if (scope.equals("token")) {
            return true;
        }
        if (scope.equals("module")) {
            return true;
        }
        if (scope.equals("overrides")) {
            return true;
        }
        switch (grammarType) {
            case 1: {
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 2: {
                if (!scope.equals("parser")) break;
                return true;
            }
            case 4: {
                if (scope.equals("parser")) {
                    return true;
                }
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 3: {
                if (!scope.equals("treeparser")) break;
                return true;
            }
        }
        return false;
    }

    public String encodeIntAsCharEscape(int v) {
        int intValue = v == 65535 ? -1 : v;
        return String.valueOf(intValue);
    }

    public class RubyRenderer
    implements AttributeRenderer {
        protected String[] rubyCharValueEscape = new String[256];

        public RubyRenderer() {
            int i;
            for (i = 0; i < 16; ++i) {
                this.rubyCharValueEscape[i] = "\\x0" + Integer.toHexString(i);
            }
            for (i = 16; i < 32; ++i) {
                this.rubyCharValueEscape[i] = "\\x" + Integer.toHexString(i);
            }
            for (i = 32; i < 127; i = (int)((char)(i + 1))) {
                this.rubyCharValueEscape[i] = Character.toString((char)i);
            }
            for (i = 127; i < 256; ++i) {
                this.rubyCharValueEscape[i] = "\\x" + Integer.toHexString(i);
            }
            this.rubyCharValueEscape[10] = "\\n";
            this.rubyCharValueEscape[13] = "\\r";
            this.rubyCharValueEscape[9] = "\\t";
            this.rubyCharValueEscape[8] = "\\b";
            this.rubyCharValueEscape[12] = "\\f";
            this.rubyCharValueEscape[92] = "\\\\";
            this.rubyCharValueEscape[34] = "\\\"";
        }

        public String toString(Object o, String formatName, Locale locale2) {
            if (formatName == null) {
                return o.toString();
            }
            String idString = o.toString();
            if (idString.length() == 0) {
                return idString;
            }
            if (formatName.equals("snakecase")) {
                return this.snakecase(idString);
            }
            if (formatName.equals("camelcase")) {
                return this.camelcase(idString);
            }
            if (formatName.equals("subcamelcase")) {
                return this.subcamelcase(idString);
            }
            if (formatName.equals("constant")) {
                return this.constantcase(idString);
            }
            if (formatName.equals("platform")) {
                return this.platform(idString);
            }
            if (formatName.equals("lexerRule")) {
                return this.lexerRule(idString);
            }
            if (formatName.equals("constantPath")) {
                return this.constantPath(idString);
            }
            if (formatName.equals("rubyString")) {
                return this.rubyString(idString);
            }
            if (formatName.equals("label")) {
                return this.label(idString);
            }
            if (formatName.equals("symbol")) {
                return this.symbol(idString);
            }
            throw new IllegalArgumentException("Unsupported format name");
        }

        private String snakecase(String value) {
            char cur;
            StringBuilder output_buffer = new StringBuilder();
            int l = value.length();
            int cliff = l - 1;
            if (value.length() == 0) {
                return value;
            }
            if (l == 1) {
                return value.toLowerCase();
            }
            for (int i = 0; i < cliff; ++i) {
                cur = value.charAt(i);
                char next = value.charAt(i + 1);
                if (Character.isLetter(cur)) {
                    char peek;
                    output_buffer.append(Character.toLowerCase(cur));
                    if (Character.isDigit(next) || Character.isWhitespace(next)) {
                        output_buffer.append('_');
                        continue;
                    }
                    if (Character.isLowerCase(cur) && Character.isUpperCase(next)) {
                        output_buffer.append('_');
                        continue;
                    }
                    if (i >= cliff - 1 || !Character.isUpperCase(cur) || !Character.isUpperCase(next) || !Character.isLowerCase(peek = value.charAt(i + 2))) continue;
                    output_buffer.append('_');
                    continue;
                }
                if (Character.isDigit(cur)) {
                    output_buffer.append(cur);
                    if (!Character.isLetter(next)) continue;
                    output_buffer.append('_');
                    continue;
                }
                if (Character.isWhitespace(cur)) continue;
                output_buffer.append(cur);
            }
            cur = value.charAt(cliff);
            if (!Character.isWhitespace(cur)) {
                output_buffer.append(Character.toLowerCase(cur));
            }
            return output_buffer.toString();
        }

        private String constantcase(String value) {
            return this.snakecase(value).toUpperCase();
        }

        private String platform(String value) {
            return "__" + value + "__";
        }

        private String symbol(String value) {
            if (value.matches("[a-zA-Z_]\\w*[\\?\\!\\=]?")) {
                return ":" + value;
            }
            return "%s(" + value + ")";
        }

        private String lexerRule(String value) {
            if (value.equals("Tokens")) {
                return "token!";
            }
            return this.snakecase(value) + "!";
        }

        private String constantPath(String value) {
            return value.replaceAll("\\.", "::");
        }

        private String rubyString(String value) {
            StringBuilder output_buffer = new StringBuilder();
            int len = value.length();
            output_buffer.append('\"');
            for (int i = 0; i < len; ++i) {
                output_buffer.append(this.rubyCharValueEscape[value.charAt(i)]);
            }
            output_buffer.append('\"');
            return output_buffer.toString();
        }

        private String camelcase(String value) {
            StringBuilder output_buffer = new StringBuilder();
            int cliff = value.length();
            boolean at_edge = true;
            if (value.length() == 0) {
                return value;
            }
            if (cliff == 1) {
                return value.toUpperCase();
            }
            for (int i = 0; i < cliff; ++i) {
                char cur = value.charAt(i);
                if (Character.isWhitespace(cur)) {
                    at_edge = true;
                    continue;
                }
                if (cur == '_') {
                    at_edge = true;
                    continue;
                }
                if (Character.isDigit(cur)) {
                    output_buffer.append(cur);
                    at_edge = true;
                    continue;
                }
                if (at_edge) {
                    output_buffer.append(Character.toUpperCase(cur));
                    if (!Character.isLetter(cur)) continue;
                    at_edge = false;
                    continue;
                }
                output_buffer.append(cur);
            }
            return output_buffer.toString();
        }

        private String label(String value) {
            if (rubyKeywords.contains(value)) {
                return this.platform(value);
            }
            if (Character.isUpperCase(value.charAt(0)) && !value.equals("FILE") && !value.equals("LINE")) {
                return this.platform(value);
            }
            if (value.equals("FILE")) {
                return "_FILE_";
            }
            if (value.equals("LINE")) {
                return "_LINE_";
            }
            return value;
        }

        private String subcamelcase(String value) {
            if ((value = this.camelcase(value)).length() == 0) {
                return value;
            }
            Character head = Character.valueOf(Character.toLowerCase(value.charAt(0)));
            String tail = value.substring(1);
            return head.toString().concat(tail);
        }
    }
}

