/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.org.antlr.tool;

import java.util.List;
import java.util.Set;
import org.openksavi.sponge.jython.shaded.org.antlr.runtime.Token;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Attribute;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.AttributeScope;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.ErrorManager;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Grammar;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.GrammarAST;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Rule;

public class NameSpaceChecker {
    protected Grammar grammar;

    public NameSpaceChecker(Grammar grammar2) {
        this.grammar = grammar2;
    }

    public void checkConflicts() {
        for (int i = 1; i < this.grammar.composite.ruleIndexToRuleList.size(); ++i) {
            Rule r = this.grammar.composite.ruleIndexToRuleList.elementAt(i);
            if (r == null) continue;
            if (r.labelNameSpace != null) {
                for (Grammar.LabelElementPair pair : r.labelNameSpace.values()) {
                    this.checkForLabelConflict(r, pair.label);
                }
            }
            if (r.ruleScope != null) {
                List<Attribute> attributes = r.ruleScope.getAttributes();
                for (int j = 0; j < attributes.size(); ++j) {
                    Attribute attribute = attributes.get(j);
                    this.checkForRuleScopeAttributeConflict(r, attribute);
                }
            }
            this.checkForRuleDefinitionProblems(r);
            this.checkForRuleArgumentAndReturnValueConflicts(r);
        }
        for (AttributeScope scope : this.grammar.getGlobalScopes().values()) {
            this.checkForGlobalScopeTokenConflict(scope);
        }
        this.lookForReferencesToUndefinedSymbols();
    }

    protected void checkForRuleArgumentAndReturnValueConflicts(Rule r) {
        Set<String> conflictingKeys;
        if (r.returnScope != null && (conflictingKeys = r.returnScope.intersection(r.parameterScope)) != null) {
            for (String key : conflictingKeys) {
                ErrorManager.grammarError(126, this.grammar, r.tree.getToken(), key, r.name);
            }
        }
    }

    protected void checkForRuleDefinitionProblems(Rule r) {
        String ruleName = r.name;
        Token ruleToken = r.tree.getToken();
        int msgID = 0;
        if ((this.grammar.type == 2 || this.grammar.type == 3) && Character.isUpperCase(ruleName.charAt(0))) {
            msgID = 102;
        } else if (this.grammar.type == 1 && Character.isLowerCase(ruleName.charAt(0)) && !r.isSynPred) {
            msgID = 103;
        } else if (this.grammar.getGlobalScope(ruleName) != null) {
            msgID = 118;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, ruleToken, ruleName);
        }
    }

    protected void lookForReferencesToUndefinedSymbols() {
        Rule rule;
        for (GrammarAST refAST : this.grammar.ruleRefs) {
            Token tok = refAST.token;
            String ruleName = tok.getText();
            Rule localRule = this.grammar.getLocallyDefinedRule(ruleName);
            rule = this.grammar.getRule(ruleName);
            if (localRule == null && rule != null) {
                this.grammar.delegatedRuleReferences.add(rule);
                rule.imported = true;
            }
            if (rule != null || this.grammar.getTokenType(ruleName) == -1) continue;
            ErrorManager.grammarError(106, this.grammar, tok, ruleName);
        }
        if (this.grammar.type == 4) {
            for (Token tok : this.grammar.tokenIDRefs) {
                String tokenID = tok.getText();
                if (this.grammar.composite.lexerRules.contains(tokenID) || this.grammar.getTokenType(tokenID) == -1) continue;
                ErrorManager.grammarWarning(105, this.grammar, tok, tokenID);
            }
        }
        for (GrammarAST scopeAST : this.grammar.scopedRuleRefs) {
            Grammar scopeG = this.grammar.composite.getGrammar(scopeAST.getText());
            GrammarAST refAST = (GrammarAST)scopeAST.getChild(1);
            String ruleName = refAST.getText();
            if (scopeG == null) {
                ErrorManager.grammarError(156, this.grammar, scopeAST.getToken(), scopeAST.getText(), ruleName);
                continue;
            }
            rule = this.grammar.getRule(scopeG.name, ruleName);
            if (rule != null) continue;
            ErrorManager.grammarError(157, this.grammar, scopeAST.getToken(), scopeAST.getText(), ruleName);
        }
    }

    protected void checkForGlobalScopeTokenConflict(AttributeScope scope) {
        if (this.grammar.getTokenType(scope.getName()) != -7) {
            ErrorManager.grammarError(118, this.grammar, null, scope.getName());
        }
    }

    public void checkForRuleScopeAttributeConflict(Rule r, Attribute attribute) {
        int msgID = 0;
        String arg2 = null;
        String attrName = attribute.name;
        if (r.name.equals(attrName)) {
            msgID = 123;
            arg2 = r.name;
        } else if (r.returnScope != null && r.returnScope.getAttribute(attrName) != null || r.parameterScope != null && r.parameterScope.getAttribute(attrName) != null) {
            msgID = 124;
            arg2 = r.name;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, r.tree.getToken(), attrName, arg2);
        }
    }

    protected void checkForLabelConflict(Rule r, Token label) {
        int msgID = 0;
        String arg2 = null;
        if (this.grammar.getGlobalScope(label.getText()) != null) {
            msgID = 118;
        } else if (this.grammar.getRule(label.getText()) != null) {
            msgID = 119;
        } else if (this.grammar.getTokenType(label.getText()) != -7) {
            msgID = 120;
        } else if (r.ruleScope != null && r.ruleScope.getAttribute(label.getText()) != null) {
            msgID = 121;
            arg2 = r.name;
        } else if (r.returnScope != null && r.returnScope.getAttribute(label.getText()) != null || r.parameterScope != null && r.parameterScope.getAttribute(label.getText()) != null) {
            msgID = 122;
            arg2 = r.name;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, label, label.getText(), arg2);
        }
    }

    public boolean checkForLabelTypeMismatch(Rule r, Token label, int type) {
        Grammar.LabelElementPair prevLabelPair = r.labelNameSpace.get(label.getText());
        if (prevLabelPair != null && prevLabelPair.type != type) {
            String typeMismatchExpr = Grammar.LabelTypeToString[type] + "!=" + Grammar.LabelTypeToString[prevLabelPair.type];
            ErrorManager.grammarError(125, this.grammar, label, label.getText(), typeMismatchExpr);
            return true;
        }
        return false;
    }
}

