/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.action.ActionBuilder;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.kb.EngineScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.plugin.BasePlugin;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.jython.JythonActionBuilder;
import org.openksavi.sponge.jython.JythonRule;
import org.openksavi.sponge.jython.PythonConstants;
import org.openksavi.sponge.jython.core.JythonKnowledgeBaseEngineOperations;
import org.openksavi.sponge.jython.util.PyBiConsumer;
import org.openksavi.sponge.jython.util.PyConsumer;
import org.openksavi.sponge.jython.util.PyPredicate;
import org.openksavi.sponge.jython.util.PySupplier;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.Rule;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.jsr223.PyScriptEngineScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonKnowledgeBaseInterpreter
extends EngineScriptKnowledgeBaseInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(JythonKnowledgeBaseInterpreter.class);
    public static final String PROP_PYTHON_PATH = "python.path";
    public static final String SCRIPT_ENGINE_NAME = "python";

    public JythonKnowledgeBaseInterpreter(SpongeEngine engine, KnowledgeBase knowledgeBase) {
        super((KnowledgeBaseEngineOperations)new JythonKnowledgeBaseEngineOperations((BaseSpongeEngine)engine, knowledgeBase), PythonConstants.TYPE);
    }

    protected ScriptEngine createScriptEngine() {
        this.overwriteProcessorClass(Rule.class, JythonRule.class);
        this.overwriteProcessorBuilderClass(ActionBuilder.class, JythonActionBuilder.class);
        this.setPythonPath(this.getEngineOperations().getEngine());
        String scripEngineName = SCRIPT_ENGINE_NAME;
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(scripEngineName);
        Validate.notNull((Object)scriptEngine, (String)"ScriptingEngine is null", (Object[])new Object[0]);
        Validate.isInstanceOf(Compilable.class, (Object)scriptEngine, (String)"ScriptingEngine %s doesn't implement Compilable", (Object[])new Object[]{scripEngineName});
        Validate.isInstanceOf(Invocable.class, (Object)scriptEngine, (String)"ScriptingEngine %s doesn't implement Invocable", (Object[])new Object[]{scripEngineName});
        this.getSimplifiedImportClasses().forEach((interfaceClass, scriptClass) -> this.addImport(scriptEngine, (Class<?>)scriptClass, interfaceClass.getSimpleName()));
        this.addImport(scriptEngine, BasePlugin.class, Plugin.class.getSimpleName());
        this.getStandardImportClasses().forEach(cls -> this.addImport(scriptEngine, (Class<?>)cls));
        this.addImport(scriptEngine, PyPredicate.class);
        this.addImport(scriptEngine, PyConsumer.class);
        this.addImport(scriptEngine, PyBiConsumer.class);
        this.addImport(scriptEngine, PySupplier.class);
        scriptEngine.put("sponge", this.getEngineOperations());
        return scriptEngine;
    }

    private void setPythonPath(SpongeEngine engine) {
        String pythonPath;
        if (engine != null && (pythonPath = this.getEngineOperations().getProperty(PROP_PYTHON_PATH, null)) != null) {
            PySystemState engineSys = new PySystemState();
            List<String> paths = Arrays.asList(StringUtils.split((String)pythonPath, (String)", \t"));
            Collections.reverse(paths);
            for (String pathElement : paths) {
                engineSys.path.add(0, Py.newString(pathElement));
            }
            Py.setSystemState(engineSys);
        }
    }

    protected void addImport(ScriptEngine scriptEngine, Class<?> clazz) {
        this.eval(scriptEngine, "from " + clazz.getPackage().getName() + " import " + clazz.getSimpleName());
    }

    protected void addImport(ScriptEngine scriptEngine, Class<?> clazz, String alias2) {
        this.eval(scriptEngine, "from " + clazz.getPackage().getName() + " import " + clazz.getSimpleName() + " as " + alias2);
    }

    public String getScriptKnowledgeBaseProcessorClassName(Object processorClass) {
        if (processorClass instanceof PyType) {
            PyType pyType = (PyType)processorClass;
            return pyType.getName();
        }
        return null;
    }

    protected ScriptKnowledgeBaseInterpreter createInterpreterInstance(SpongeEngine engine, KnowledgeBase knowledgeBase) {
        return new JythonKnowledgeBaseInterpreter(engine, knowledgeBase);
    }

    public void scanToAutoEnable() {
        PyScriptEngineScope scope = (PyScriptEngineScope)this.eval("globals()");
        List processorPyTypes = this.getProcessorClasses().values().stream().map(cls -> (PyType)Py.java2py(cls)).collect(Collectors.toList());
        ArrayList autoEnabled = new ArrayList();
        SpongeUtils.stream(((PyScriptEngineScope.ScopeIterator)scope.__iter__()).iterator()).forEachOrdered(element -> {
            String name = element.toString();
            PyObject pyObject = scope.__finditem__(name);
            if (pyObject != null && pyObject instanceof PyType && !(pyObject instanceof PyJavaType)) {
                PyType pyType = (PyType)pyObject;
                boolean extendsProcessorType = processorPyTypes.stream().filter(processorClass -> !pyType.equals(processorClass) && pyType.isSubType((PyType)processorClass)).findFirst().isPresent();
                if (extendsProcessorType && !this.isProcessorAbstract(name)) {
                    autoEnabled.add(name);
                    ((JythonKnowledgeBaseEngineOperations)this.getEngineOperations()).enable(pyType);
                }
            }
        });
        if (logger.isDebugEnabled() && !autoEnabled.isEmpty()) {
            logger.debug("Auto-enabling: {}", autoEnabled);
        }
    }

    protected String getScriptClassInstancePoviderFormat() {
        return "%s()";
    }

    public String getSpecificExceptionMessage(Throwable e) {
        if (e.getMessage() != null && (e instanceof ScriptException || e instanceof PyException)) {
            return SpongeUtils.removeLeadingExceptionClassNamesFromMessage((Throwable)e);
        }
        if (e.getMessage() == null && e instanceof PyException) {
            return e.toString();
        }
        return null;
    }
}

