/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.DFA;
import org.openksavi.sponge.jython.shaded.org.antlr.codegen.CodeGenerator;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Grammar;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.GrammarAST;
import org.openksavi.sponge.jython.shaded.org.stringtemplate.v4.ST;
import org.openksavi.sponge.jython.shaded.org.stringtemplate.v4.STGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate(-2);

    public abstract SemanticContext getGatedPredicateContext();

    public abstract ST genExpr(CodeGenerator var1, STGroup var2, DFA var3);

    public abstract boolean hasUserSemanticPredicate();

    public abstract boolean isSyntacticPredicate();

    public void trackUseOfSyntacticPredicates(Grammar g) {
    }

    public static SemanticContext and(SemanticContext a, SemanticContext b) {
        boolean factored;
        if (a instanceof FalsePredicate || b instanceof FalsePredicate) {
            return new FalsePredicate();
        }
        SemanticContext[] terms = SemanticContext.factorOr(a, b);
        SemanticContext commonTerms = terms[0];
        a = terms[1];
        b = terms[2];
        boolean bl = factored = commonTerms != null && commonTerms != EMPTY_SEMANTIC_CONTEXT && !(commonTerms instanceof TruePredicate);
        if (factored) {
            return SemanticContext.or(commonTerms, SemanticContext.and(a, b));
        }
        if (a instanceof FalsePredicate || b instanceof FalsePredicate) {
            return new FalsePredicate();
        }
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null) {
            return b;
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null) {
            return a;
        }
        if (a instanceof TruePredicate) {
            return b;
        }
        if (b instanceof TruePredicate) {
            return a;
        }
        AND result2 = new AND(a, b);
        if (result2.operands.size() == 1) {
            return (SemanticContext)result2.operands.iterator().next();
        }
        return result2;
    }

    public static SemanticContext or(SemanticContext a, SemanticContext b) {
        NOT n;
        boolean factored;
        if (a instanceof TruePredicate || b instanceof TruePredicate) {
            return new TruePredicate();
        }
        SemanticContext[] terms = SemanticContext.factorAnd(a, b);
        SemanticContext commonTerms = terms[0];
        a = terms[1];
        b = terms[2];
        boolean bl = factored = commonTerms != null && commonTerms != EMPTY_SEMANTIC_CONTEXT && !(commonTerms instanceof FalsePredicate);
        if (factored) {
            return SemanticContext.and(commonTerms, SemanticContext.or(a, b));
        }
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null || a instanceof FalsePredicate) {
            return b;
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null || b instanceof FalsePredicate) {
            return a;
        }
        if (a instanceof TruePredicate || b instanceof TruePredicate || commonTerms instanceof TruePredicate) {
            return new TruePredicate();
        }
        if (a instanceof NOT) {
            n = (NOT)a;
            if (n.ctx.equals(b)) {
                return new TruePredicate();
            }
        } else if (b instanceof NOT) {
            n = (NOT)b;
            if (n.ctx.equals(a)) {
                return new TruePredicate();
            }
        }
        OR result2 = new OR(a, b);
        if (result2.operands.size() == 1) {
            return (SemanticContext)result2.operands.iterator().next();
        }
        return result2;
    }

    public static SemanticContext not(SemanticContext a) {
        if (a instanceof NOT) {
            return ((NOT)a).ctx;
        }
        if (a instanceof TruePredicate) {
            return new FalsePredicate();
        }
        if (a instanceof FalsePredicate) {
            return new TruePredicate();
        }
        return new NOT(a);
    }

    public static SemanticContext[] factorAnd(SemanticContext a, SemanticContext b) {
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null || a instanceof FalsePredicate) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a, b};
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null || b instanceof FalsePredicate) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a, b};
        }
        if (a instanceof TruePredicate || b instanceof TruePredicate) {
            return new SemanticContext[]{new TruePredicate(), EMPTY_SEMANTIC_CONTEXT, EMPTY_SEMANTIC_CONTEXT};
        }
        HashSet<SemanticContext> opsA = new HashSet<SemanticContext>(SemanticContext.getAndOperands(a));
        HashSet<SemanticContext> opsB = new HashSet<SemanticContext>(SemanticContext.getAndOperands(b));
        HashSet<SemanticContext> result2 = new HashSet<SemanticContext>(opsA);
        result2.retainAll(opsB);
        if (result2.isEmpty()) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a, b};
        }
        opsA.removeAll(result2);
        a = opsA.isEmpty() ? new TruePredicate() : (opsA.size() == 1 ? opsA.iterator().next() : new AND(opsA));
        opsB.removeAll(result2);
        b = opsB.isEmpty() ? new TruePredicate() : (opsB.size() == 1 ? opsB.iterator().next() : new AND(opsB));
        if (result2.size() == 1) {
            return new SemanticContext[]{result2.iterator().next(), a, b};
        }
        return new SemanticContext[]{new AND(result2), a, b};
    }

    public static SemanticContext[] factorOr(SemanticContext a, SemanticContext b) {
        HashSet<SemanticContext> opsA = new HashSet<SemanticContext>(SemanticContext.getOrOperands(a));
        HashSet<SemanticContext> opsB = new HashSet<SemanticContext>(SemanticContext.getOrOperands(b));
        HashSet<SemanticContext> result2 = new HashSet<SemanticContext>(opsA);
        result2.retainAll(opsB);
        if (result2.isEmpty()) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a, b};
        }
        opsA.removeAll(result2);
        a = opsA.isEmpty() ? new FalsePredicate() : (opsA.size() == 1 ? opsA.iterator().next() : new OR(opsA));
        opsB.removeAll(result2);
        b = opsB.isEmpty() ? new FalsePredicate() : (opsB.size() == 1 ? opsB.iterator().next() : new OR(opsB));
        if (result2.size() == 1) {
            return new SemanticContext[]{result2.iterator().next(), a, b};
        }
        return new SemanticContext[]{new OR(result2), a, b};
    }

    public static Collection<SemanticContext> getAndOperands(SemanticContext context) {
        if (context instanceof AND) {
            return ((AND)context).operands;
        }
        if (context instanceof NOT) {
            Collection<SemanticContext> operands = SemanticContext.getOrOperands(((NOT)context).ctx);
            ArrayList<SemanticContext> result2 = new ArrayList<SemanticContext>(operands.size());
            for (SemanticContext operand : operands) {
                result2.add(SemanticContext.not(operand));
            }
            return result2;
        }
        ArrayList<SemanticContext> result3 = new ArrayList<SemanticContext>();
        result3.add(context);
        return result3;
    }

    public static Collection<SemanticContext> getOrOperands(SemanticContext context) {
        if (context instanceof OR) {
            return ((OR)context).operands;
        }
        if (context instanceof NOT) {
            Collection<SemanticContext> operands = SemanticContext.getAndOperands(((NOT)context).ctx);
            ArrayList<SemanticContext> result2 = new ArrayList<SemanticContext>(operands.size());
            for (SemanticContext operand : operands) {
                result2.add(SemanticContext.not(operand));
            }
            return result2;
        }
        ArrayList<SemanticContext> result3 = new ArrayList<SemanticContext>();
        result3.add(context);
        return result3;
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public NOT(SemanticContext ctx) {
            this.ctx = ctx;
        }

        public ST genExpr(CodeGenerator generator2, STGroup templates, DFA dfa) {
            ST eST = templates != null ? templates.getInstanceOf("notPredicate") : new ST("!(<pred>)");
            eST.add("pred", this.ctx.genExpr(generator2, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext p = this.ctx.getGatedPredicateContext();
            if (p == null) {
                return null;
            }
            return new NOT(p);
        }

        public boolean hasUserSemanticPredicate() {
            return this.ctx.hasUserSemanticPredicate();
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            this.ctx.trackUseOfSyntacticPredicates(g);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NOT)) {
                return false;
            }
            return this.ctx.equals(((NOT)object).ctx);
        }

        public int hashCode() {
            return ~this.ctx.hashCode();
        }

        public String toString() {
            return "!(" + this.ctx + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OR
    extends CommutativePredicate {
        public OR(SemanticContext a, SemanticContext b) {
            super(a, b);
        }

        public OR(HashSet<SemanticContext> contexts) {
            super(contexts);
        }

        @Override
        public ST genExpr(CodeGenerator generator2, STGroup templates, DFA dfa) {
            ST eST = templates != null ? templates.getInstanceOf("orPredicates") : new ST("(<operands; separator=\"||\">)");
            for (SemanticContext semctx : this.operands) {
                eST.add("operands", semctx.genExpr(generator2, templates, dfa));
            }
            return eST;
        }

        @Override
        public String getOperandString() {
            return "||";
        }

        @Override
        public SemanticContext combinePredicates(SemanticContext left, SemanticContext right) {
            return SemanticContext.or(left, right);
        }

        @Override
        public int calculateHashCode() {
            int hashcode = 0;
            for (SemanticContext context : this.operands) {
                hashcode = ~hashcode ^ context.hashCode();
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AND
    extends CommutativePredicate {
        public AND(SemanticContext a, SemanticContext b) {
            super(a, b);
        }

        public AND(HashSet<SemanticContext> contexts) {
            super(contexts);
        }

        @Override
        public ST genExpr(CodeGenerator generator2, STGroup templates, DFA dfa) {
            ST result2 = null;
            for (SemanticContext operand : this.operands) {
                if (result2 == null) {
                    result2 = operand.genExpr(generator2, templates, dfa);
                    continue;
                }
                ST eST = templates != null ? templates.getInstanceOf("andPredicates") : new ST("(<left>&&<right>)");
                eST.add("left", result2);
                eST.add("right", operand.genExpr(generator2, templates, dfa));
                result2 = eST;
            }
            return result2;
        }

        @Override
        public String getOperandString() {
            return "&&";
        }

        @Override
        public SemanticContext combinePredicates(SemanticContext left, SemanticContext right) {
            return SemanticContext.and(left, right);
        }

        @Override
        public int calculateHashCode() {
            int hashcode = 0;
            for (SemanticContext context : this.operands) {
                hashcode ^= context.hashCode();
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CommutativePredicate
    extends SemanticContext {
        protected final Set<SemanticContext> operands = new HashSet<SemanticContext>();
        protected int hashcode;

        public CommutativePredicate(SemanticContext a, SemanticContext b) {
            CommutativePredicate predicate;
            if (a.getClass() == this.getClass()) {
                predicate = (CommutativePredicate)a;
                this.operands.addAll(predicate.operands);
            } else {
                this.operands.add(a);
            }
            if (b.getClass() == this.getClass()) {
                predicate = (CommutativePredicate)b;
                this.operands.addAll(predicate.operands);
            } else {
                this.operands.add(b);
            }
            this.hashcode = this.calculateHashCode();
        }

        public CommutativePredicate(HashSet<SemanticContext> contexts) {
            for (SemanticContext context : contexts) {
                if (context.getClass() == this.getClass()) {
                    CommutativePredicate predicate = (CommutativePredicate)context;
                    this.operands.addAll(predicate.operands);
                    continue;
                }
                this.operands.add(context);
            }
            this.hashcode = this.calculateHashCode();
        }

        @Override
        public SemanticContext getGatedPredicateContext() {
            SemanticContext result2 = null;
            for (SemanticContext semctx : this.operands) {
                SemanticContext gatedPred = semctx.getGatedPredicateContext();
                if (gatedPred == null) continue;
                result2 = this.combinePredicates(result2, gatedPred);
            }
            return result2;
        }

        @Override
        public boolean hasUserSemanticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.hasUserSemanticPredicate()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSyntacticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.isSyntacticPredicate()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void trackUseOfSyntacticPredicates(Grammar g) {
            for (SemanticContext semctx : this.operands) {
                semctx.trackUseOfSyntacticPredicates(g);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                CommutativePredicate commutative = (CommutativePredicate)obj;
                Set<SemanticContext> otherOperands = commutative.operands;
                if (this.operands.size() != otherOperands.size()) {
                    return false;
                }
                return this.operands.containsAll(otherOperands);
            }
            if (obj instanceof NOT) {
                NOT not = (NOT)obj;
                if (not.ctx instanceof CommutativePredicate && not.ctx.getClass() != this.getClass()) {
                    Set<SemanticContext> otherOperands = ((CommutativePredicate)not.ctx).operands;
                    if (this.operands.size() != otherOperands.size()) {
                        return false;
                    }
                    ArrayList<SemanticContext> temp = new ArrayList<SemanticContext>(this.operands.size());
                    for (SemanticContext context : otherOperands) {
                        temp.add(CommutativePredicate.not(context));
                    }
                    return this.operands.containsAll(temp);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            int i = 0;
            for (SemanticContext semctx : this.operands) {
                if (i > 0) {
                    buf.append(this.getOperandString());
                }
                buf.append(semctx.toString());
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }

        public abstract String getOperandString();

        public abstract SemanticContext combinePredicates(SemanticContext var1, SemanticContext var2);

        public abstract int calculateHashCode();
    }

    public static class FalsePredicate
    extends Predicate {
        public FalsePredicate() {
            super(0);
        }

        public ST genExpr(CodeGenerator generator2, STGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("false");
            }
            return new ST("false");
        }

        public boolean hasUserSemanticPredicate() {
            return false;
        }

        public String toString() {
            return "false";
        }
    }

    public static class TruePredicate
    extends Predicate {
        public TruePredicate() {
            super(-1);
        }

        public ST genExpr(CodeGenerator generator2, STGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("true_value");
            }
            return new ST("true");
        }

        public boolean hasUserSemanticPredicate() {
            return false;
        }

        public String toString() {
            return "true";
        }
    }

    public static class Predicate
    extends SemanticContext {
        public GrammarAST predicateAST;
        protected boolean gated = false;
        protected boolean synpred = false;
        public static final int INVALID_PRED_VALUE = -2;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = -1;
        protected int constantValue = -2;

        public Predicate(int constantValue) {
            this.predicateAST = new GrammarAST();
            this.constantValue = constantValue;
        }

        public Predicate(GrammarAST predicate) {
            this.predicateAST = predicate;
            this.gated = predicate.getType() == 41 || predicate.getType() == 90;
            this.synpred = predicate.getType() == 90 || predicate.getType() == 14;
        }

        public Predicate(Predicate p) {
            this.predicateAST = p.predicateAST;
            this.gated = p.gated;
            this.synpred = p.synpred;
            this.constantValue = p.constantValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Predicate)) {
                return false;
            }
            Predicate other = (Predicate)o;
            if (this.constantValue != other.constantValue) {
                return false;
            }
            if (this.constantValue != -2) {
                return true;
            }
            return this.predicateAST.getText().equals(other.predicateAST.getText());
        }

        public int hashCode() {
            if (this.constantValue != -2) {
                return this.constantValue;
            }
            if (this.predicateAST == null) {
                return 0;
            }
            return this.predicateAST.getText().hashCode();
        }

        public ST genExpr(CodeGenerator generator2, STGroup templates, DFA dfa) {
            ST eST;
            if (templates != null) {
                if (this.synpred) {
                    eST = templates.getInstanceOf("evalSynPredicate");
                } else {
                    eST = templates.getInstanceOf("evalPredicate");
                    generator2.grammar.decisionsWhoseDFAsUsesSemPreds.add(dfa);
                }
                String predEnclosingRuleName = this.predicateAST.enclosingRuleName;
                if (generator2 != null) {
                    eST.add("pred", generator2.translateAction(predEnclosingRuleName, this.predicateAST));
                }
            } else {
                ST eST2 = new ST("<pred>");
                eST2.add("pred", this.toString());
                return eST2;
            }
            if (generator2 != null) {
                String description = generator2.target.getTargetStringLiteralFromString(this.toString());
                eST.add("description", description);
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean hasUserSemanticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 41 || this.predicateAST.getType() == 83);
        }

        public boolean isSyntacticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 90 || this.predicateAST.getType() == 14);
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            if (this.synpred) {
                g.synPredNamesUsedInDFA.add(this.predicateAST.getText());
            }
        }

        public String toString() {
            if (this.predicateAST == null) {
                return "<nopred>";
            }
            return this.predicateAST.getText();
        }
    }
}

