/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.org.antlr.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.openksavi.sponge.jython.shaded.org.antlr.Tool;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.Label;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.NFAState;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.RuleClosureTransition;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.Transition;
import org.openksavi.sponge.jython.shaded.org.antlr.misc.IntervalSet;
import org.openksavi.sponge.jython.shaded.org.antlr.misc.Utils;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.CompositeGrammar;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Grammar;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomPhrase {
    public static final boolean debug = false;
    protected static Random random;

    protected static void randomPhrase(Grammar g, List<Integer> tokenTypes, String startRule) {
        NFAState state = g.getRuleStartState(startRule);
        NFAState stopState = g.getRuleStopState(startRule);
        Stack<NFAState> ruleInvocationStack = new Stack<NFAState>();
        while (state != stopState || !ruleInvocationStack.isEmpty()) {
            if (state.getNumberOfTransitions() == 0) {
                return;
            }
            if (state.isAcceptState()) {
                NFAState invokingState = (NFAState)ruleInvocationStack.pop();
                RuleClosureTransition invokingTransition = (RuleClosureTransition)invokingState.transition[0];
                state = invokingTransition.followState;
                continue;
            }
            if (state.getNumberOfTransitions() == 1) {
                Transition t0 = state.transition[0];
                if (t0 instanceof RuleClosureTransition) {
                    ruleInvocationStack.push(state);
                } else if (t0.label.isSet() || t0.label.isAtom()) {
                    tokenTypes.add(RandomPhrase.getTokenType(t0.label));
                }
                state = (NFAState)t0.target;
                continue;
            }
            int decisionNumber = state.getDecisionNumber();
            if (decisionNumber == 0) {
                System.out.println("weird: no decision number but a choice node");
                continue;
            }
            int n = g.getNumberOfAltsForDecisionNFA(state);
            int randomAlt = random.nextInt(n) + 1;
            NFAState altStartState = g.getNFAStateForAltOfDecision(state, randomAlt);
            Transition t = altStartState.transition[0];
            state = (NFAState)t.target;
        }
    }

    protected static Integer getTokenType(Label label) {
        if (label.isSet()) {
            IntervalSet typeSet = (IntervalSet)label.getSet();
            int randomIndex = random.nextInt(typeSet.size());
            return typeSet.get(randomIndex);
        }
        return Utils.integer(label.getAtom());
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("usage: java org.antlr.tool.RandomPhrase grammarfile startrule");
            return;
        }
        String grammarFileName = args[0];
        String startRule = args[1];
        long seed = System.currentTimeMillis();
        if (args.length == 3) {
            String seedStr = args[2];
            seed = Long.parseLong(seedStr);
        }
        try {
            random = new Random(seed);
            CompositeGrammar composite = new CompositeGrammar();
            Tool tool2 = new Tool();
            Grammar parser2 = new Grammar(tool2, grammarFileName, composite);
            composite.setDelegationRoot(parser2);
            FileReader fr = new FileReader(grammarFileName);
            BufferedReader br = new BufferedReader(fr);
            parser2.parseAndBuildAST(br);
            br.close();
            parser2.composite.assignTokenTypes();
            parser2.composite.defineGrammarSymbols();
            parser2.composite.createNFAs();
            List<? extends Collection<? extends Rule>> leftRecursiveRules = parser2.checkAllRulesForLeftRecursion();
            if (leftRecursiveRules.size() > 0) {
                return;
            }
            if (parser2.getRule(startRule) == null) {
                System.out.println("undefined start rule " + startRule);
                return;
            }
            String lexerGrammarText = parser2.getLexerGrammar();
            Grammar lexer = new Grammar(tool2);
            lexer.importTokenVocabulary(parser2);
            lexer.fileName = grammarFileName;
            if (lexerGrammarText != null) {
                lexer.setGrammarContent(lexerGrammarText);
            } else {
                System.err.println("no lexer grammar found in " + grammarFileName);
            }
            lexer.buildNFA();
            leftRecursiveRules = lexer.checkAllRulesForLeftRecursion();
            if (leftRecursiveRules.size() > 0) {
                return;
            }
            ArrayList<Integer> tokenTypes = new ArrayList<Integer>(100);
            RandomPhrase.randomPhrase(parser2, tokenTypes, startRule);
            System.out.println("token types=" + tokenTypes);
            for (int i = 0; i < tokenTypes.size(); ++i) {
                Integer ttypeI = (Integer)tokenTypes.get(i);
                int ttype = ttypeI;
                String ttypeDisplayName = parser2.getTokenDisplayName(ttype);
                if (Character.isUpperCase(ttypeDisplayName.charAt(0))) {
                    ArrayList<Integer> charsInToken = new ArrayList<Integer>(10);
                    RandomPhrase.randomPhrase(lexer, charsInToken, ttypeDisplayName);
                    System.out.print(" ");
                    for (int j = 0; j < charsInToken.size(); ++j) {
                        Integer cI = (Integer)charsInToken.get(j);
                        System.out.print((char)cI.intValue());
                    }
                    continue;
                }
                String literal = ttypeDisplayName.substring(1, ttypeDisplayName.length() - 1);
                System.out.print(" " + literal);
            }
            System.out.println();
        }
        catch (Error er) {
            System.err.println("Error walking " + grammarFileName + " rule " + startRule + " seed " + seed);
            er.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.err.println("Exception walking " + grammarFileName + " rule " + startRule + " seed " + seed);
            e.printStackTrace(System.err);
        }
    }
}

