/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.jnr.ffi;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Platform {
    private static final Locale LOCALE = Locale.ENGLISH;
    private final OS os;
    private final CPU cpu;
    private final int addressSize;
    private final int longSize;
    protected final Pattern libPattern;

    private static OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (Platform.startsWithIgnoreCase(osName, "mac") || Platform.startsWithIgnoreCase(osName, "darwin")) {
            return OS.DARWIN;
        }
        if (Platform.startsWithIgnoreCase(osName, "linux")) {
            return OS.LINUX;
        }
        if (Platform.startsWithIgnoreCase(osName, "sunos") || Platform.startsWithIgnoreCase(osName, "solaris")) {
            return OS.SOLARIS;
        }
        if (Platform.startsWithIgnoreCase(osName, "aix")) {
            return OS.AIX;
        }
        if (Platform.startsWithIgnoreCase(osName, "openbsd")) {
            return OS.OPENBSD;
        }
        if (Platform.startsWithIgnoreCase(osName, "freebsd")) {
            return OS.FREEBSD;
        }
        if (Platform.startsWithIgnoreCase(osName, "dragonfly")) {
            return OS.DRAGONFLY;
        }
        if (Platform.startsWithIgnoreCase(osName, "windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static Platform determinePlatform(OS os2) {
        switch (os2) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                return new Unsupported(os2);
            }
        }
        return new Default(os2);
    }

    private static Platform determinePlatform() {
        String providerName = System.getProperty("org.openksavi.sponge.jython.shaded.jnr.ffi.provider");
        try {
            Class<?> c = Class.forName(providerName + "$Platform");
            return (Platform)c.newInstance();
        }
        catch (ClassNotFoundException ex) {
            return Platform.determinePlatform(Platform.determineOS());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private static CPU determineCPU() {
        String archString = System.getProperty("os.arch");
        if (Platform.equalsIgnoreCase("x86", archString) || Platform.equalsIgnoreCase("i386", archString) || Platform.equalsIgnoreCase("i86pc", archString) || Platform.equalsIgnoreCase("i686", archString)) {
            return CPU.I386;
        }
        if (Platform.equalsIgnoreCase("x86_64", archString) || Platform.equalsIgnoreCase("amd64", archString)) {
            return CPU.X86_64;
        }
        if (Platform.equalsIgnoreCase("ppc", archString) || Platform.equalsIgnoreCase("powerpc", archString)) {
            return CPU.PPC;
        }
        if (Platform.equalsIgnoreCase("ppc64", archString) || Platform.equalsIgnoreCase("powerpc64", archString)) {
            if ("little".equals(System.getProperty("sun.cpu.endian"))) {
                return CPU.PPC64LE;
            }
            return CPU.PPC64;
        }
        if (Platform.equalsIgnoreCase("ppc64le", archString) || Platform.equalsIgnoreCase("powerpc64le", archString)) {
            return CPU.PPC64LE;
        }
        if (Platform.equalsIgnoreCase("s390", archString) || Platform.equalsIgnoreCase("s390x", archString)) {
            return CPU.S390X;
        }
        if (Platform.equalsIgnoreCase("aarch64", archString)) {
            return CPU.AARCH64;
        }
        if (Platform.equalsIgnoreCase("arm", archString) || Platform.equalsIgnoreCase("armv7l", archString)) {
            return CPU.ARM;
        }
        for (CPU cpu : CPU.values()) {
            if (!Platform.equalsIgnoreCase(cpu.name(), archString)) continue;
            return cpu;
        }
        return CPU.UNKNOWN;
    }

    public Platform(OS os2, CPU cpu, int addressSize, int longSize, String libPattern) {
        this.os = os2;
        this.cpu = cpu;
        this.addressSize = addressSize;
        this.longSize = longSize;
        this.libPattern = Pattern.compile(libPattern);
    }

    private Platform(OS os2) {
        String libpattern;
        this.os = os2;
        this.cpu = Platform.determineCPU();
        switch (os2) {
            case WINDOWS: {
                libpattern = ".*\\.dll$";
                break;
            }
            case DARWIN: {
                libpattern = "lib.*\\.(dylib|jnilib)$";
                break;
            }
            default: {
                libpattern = "lib.*\\.so.*$";
            }
        }
        this.libPattern = Pattern.compile(libpattern);
        this.addressSize = Platform.calculateAddressSize(this.cpu);
        this.longSize = os2 == OS.WINDOWS ? 32 : this.addressSize;
    }

    private static int calculateAddressSize(CPU cpu) {
        Integer dataModel = Integer.getInteger("sun.arch.data.model");
        if (dataModel == null || dataModel != 32 && dataModel != 64) {
            switch (cpu) {
                case I386: 
                case PPC: 
                case SPARC: {
                    dataModel = 32;
                    break;
                }
                case X86_64: 
                case PPC64: 
                case PPC64LE: 
                case SPARCV9: 
                case S390X: 
                case AARCH64: {
                    dataModel = 64;
                    break;
                }
                default: {
                    throw new ExceptionInInitializerError("Cannot determine cpu address size");
                }
            }
        }
        return dataModel;
    }

    public static Platform getNativePlatform() {
        return SingletonHolder.PLATFORM;
    }

    @Deprecated
    public static Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final boolean isBSD() {
        return this.os == OS.FREEBSD || this.os == OS.OPENBSD || this.os == OS.NETBSD || this.os == OS.DARWIN || this.os == OS.DRAGONFLY;
    }

    public final boolean isUnix() {
        return this.os != OS.WINDOWS;
    }

    public final int longSize() {
        return this.longSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public String getName() {
        return (Object)((Object)this.cpu) + "-" + (Object)((Object)this.os);
    }

    public String getStandardCLibraryName() {
        switch (this.os) {
            case LINUX: {
                return "libc.so.6";
            }
            case SOLARIS: {
                return "c";
            }
            case DRAGONFLY: 
            case FREEBSD: 
            case NETBSD: {
                return "c";
            }
            case AIX: {
                return this.addressSize == 32 ? "libc.a(shr.o)" : "libc.a(shr_64.o)";
            }
            case WINDOWS: {
                return "msvcrt";
            }
        }
        return "c";
    }

    public String mapLibraryName(String libName) {
        if (this.libPattern.matcher(libName).find()) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    public String locateLibrary(String libName, List<String> libraryPath) {
        String mappedName = this.mapLibraryName(libName);
        for (String path : libraryPath) {
            File libFile = new File(path, mappedName);
            if (!libFile.exists()) continue;
            return libFile.getAbsolutePath();
        }
        return mappedName;
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.startsWith(s2) || s1.toUpperCase(LOCALE).startsWith(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).startsWith(s2.toLowerCase(LOCALE));
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1.equalsIgnoreCase(s2) || s1.toUpperCase(LOCALE).equals(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).equals(s2.toLowerCase(LOCALE));
    }

    static /* synthetic */ Platform access$000() {
        return Platform.determinePlatform();
    }

    private static class Windows
    extends Supported {
        public Windows() {
            super(OS.WINDOWS);
        }
    }

    static final class Linux
    extends Supported {
        public Linux() {
            super(OS.LINUX);
        }

        @Override
        public String locateLibrary(String libName, List<String> libraryPaths) {
            Pattern exclude = this.getCPU() == CPU.X86_64 ? Pattern.compile(".*(lib[a-z]*32|i[0-9]86).*") : Pattern.compile(".*(lib[a-z]*64|amd64|x86_64).*");
            final Pattern versionedLibPattern = Pattern.compile("lib" + libName + "\\.so((?:\\.[0-9]+)*)$");
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return versionedLibPattern.matcher(name).matches();
                }
            };
            LinkedHashMap<String, int[]> matches = new LinkedHashMap<String, int[]>();
            for (String path : libraryPaths) {
                File libraryPath;
                File[] files;
                if (exclude.matcher(path).matches() || (files = (libraryPath = new File(path)).listFiles(filter)) == null) continue;
                for (File file : files) {
                    int[] version2;
                    String versionString;
                    Matcher matcher = versionedLibPattern.matcher(file.getName());
                    String string2 = versionString = matcher.matches() ? matcher.group(1) : "";
                    if (versionString == null || versionString.isEmpty()) {
                        version2 = new int[]{};
                    } else {
                        String[] parts = versionString.split("\\.");
                        version2 = new int[parts.length - 1];
                        for (int i = 1; i < parts.length; ++i) {
                            version2[i - 1] = Integer.parseInt(parts[i]);
                        }
                    }
                    matches.put(file.getAbsolutePath(), version2);
                }
            }
            int[] bestVersion = null;
            String bestMatch = null;
            for (Map.Entry entry : matches.entrySet()) {
                String file = (String)entry.getKey();
                int[] fileVersion = (int[])entry.getValue();
                if (Linux.compareVersions(fileVersion, bestVersion) <= 0) continue;
                bestMatch = file;
                bestVersion = fileVersion;
            }
            return bestMatch != null ? bestMatch : this.mapLibraryName(libName);
        }

        private static int compareVersions(int[] version1, int[] version2) {
            if (version1 == null) {
                return version2 == null ? 0 : -1;
            }
            if (version2 == null) {
                return 1;
            }
            int commonLength = Math.min(version1.length, version2.length);
            for (int i = 0; i < commonLength; ++i) {
                if (version1[i] < version2[i]) {
                    return -1;
                }
                if (version1[i] <= version2[i]) continue;
                return 1;
            }
            if (version1.length < version2.length) {
                return -1;
            }
            if (version1.length > version2.length) {
                return 1;
            }
            return 0;
        }

        @Override
        public String mapLibraryName(String libName) {
            return "c".equals(libName) || "libc.so".equals(libName) ? "libc.so.6" : super.mapLibraryName(libName);
        }
    }

    private static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS.DARWIN);
        }

        @Override
        public String mapLibraryName(String libName) {
            if (this.libPattern.matcher(libName).find()) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }

        @Override
        public String getName() {
            return "Darwin";
        }
    }

    private static final class Default
    extends Supported {
        public Default(OS os2) {
            super(os2);
        }
    }

    private static class Unsupported
    extends Platform {
        public Unsupported(OS os2) {
            super(os2);
        }
    }

    private static class Supported
    extends Platform {
        public Supported(OS os2) {
            super(os2);
        }
    }

    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        PPC64LE,
        SPARC,
        SPARCV9,
        S390X,
        MIPS32,
        ARM,
        AARCH64,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        DRAGONFLY,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    private static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$000();

        private SingletonHolder() {
        }
    }
}

