/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.jnr.posix;

import java.io.File;
import java.io.IOException;
import org.openksavi.sponge.jython.shaded.jnr.posix.FileStat;
import org.openksavi.sponge.jython.shaded.jnr.posix.JavaSecuredFile;
import org.openksavi.sponge.jython.shaded.jnr.posix.POSIX;
import org.openksavi.sponge.jython.shaded.jnr.posix.POSIXHandler;

public class JavaFileStat
implements FileStat {
    private final POSIXHandler handler;
    private final POSIX posix;
    short st_mode;
    int st_blksize;
    long st_size;
    int st_ctime;
    int st_mtime;

    public JavaFileStat(POSIX posix, POSIXHandler handler2) {
        this.handler = handler2;
        this.posix = posix;
    }

    public void setup(String path) {
        JavaSecuredFile file = new JavaSecuredFile(path);
        this.st_blksize = 4096;
        this.st_mode = this.calculateMode(file, this.st_mode);
        this.st_size = ((File)file).length();
        this.st_mtime = (int)(((File)file).lastModified() / 1000L);
        this.st_ctime = ((File)file).getParentFile() != null ? (int)(((File)file).getParentFile().lastModified() / 1000L) : this.st_mtime;
    }

    private short calculateMode(File file, short st_mode) {
        if (file.canRead()) {
            st_mode = (short)(st_mode | 0x124);
        }
        if (file.canWrite()) {
            st_mode = (short)(st_mode | 0x92);
            st_mode = (short)(st_mode & 0xFFFFFFED);
        }
        if (file.isDirectory()) {
            st_mode = (short)(st_mode | 0x4000);
        } else if (file.isFile()) {
            st_mode = (short)(st_mode | 0x8000);
        }
        try {
            st_mode = this.calculateSymlink(file, st_mode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return st_mode;
    }

    private short calculateSymlink(File file, short st_mode) throws IOException {
        if (file.getAbsoluteFile().getParentFile() == null) {
            return st_mode;
        }
        File absoluteParent = file.getAbsoluteFile().getParentFile();
        File canonicalParent = absoluteParent.getCanonicalFile();
        if (canonicalParent.getAbsolutePath().equals(absoluteParent.getAbsolutePath()) && !file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath())) {
            st_mode = (short)(st_mode | 0xA000);
            return st_mode;
        }
        file = new JavaSecuredFile(canonicalParent.getAbsolutePath() + "/" + file.getName());
        if (!file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath())) {
            st_mode = (short)(st_mode | 0xA000);
        }
        return st_mode;
    }

    @Override
    public long atime() {
        return this.st_mtime;
    }

    @Override
    public long blocks() {
        this.handler.unimplementedError("stat.st_blocks");
        return -1L;
    }

    @Override
    public long blockSize() {
        return this.st_blksize;
    }

    @Override
    public long ctime() {
        return this.st_ctime;
    }

    @Override
    public long dev() {
        this.handler.unimplementedError("stat.st_dev");
        return -1L;
    }

    @Override
    public String ftype() {
        if (this.isFile()) {
            return "file";
        }
        if (this.isDirectory()) {
            return "directory";
        }
        return "unknown";
    }

    @Override
    public int gid() {
        this.handler.unimplementedError("stat.st_gid");
        return -1;
    }

    @Override
    public boolean groupMember(int gid) {
        return this.posix.getgid() == gid || this.posix.getegid() == gid;
    }

    @Override
    public long ino() {
        return 0L;
    }

    @Override
    public boolean isBlockDev() {
        this.handler.unimplementedError("block device detection");
        return false;
    }

    @Override
    public boolean isCharDev() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return (this.mode() & 0x4000) != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.st_size() == 0L;
    }

    @Override
    public boolean isExecutable() {
        this.handler.warn(POSIXHandler.WARNING_ID.DUMMY_VALUE_USED, "executable? does not in this environment and will return a dummy value", "executable");
        return true;
    }

    @Override
    public boolean isExecutableReal() {
        this.handler.warn(POSIXHandler.WARNING_ID.DUMMY_VALUE_USED, "executable_real? does not work in this environmnt and will return a dummy value", "executable_real");
        return true;
    }

    @Override
    public boolean isFifo() {
        this.handler.unimplementedError("fifo file detection");
        return false;
    }

    @Override
    public boolean isFile() {
        return (this.mode() & 0x8000) != 0;
    }

    @Override
    public boolean isGroupOwned() {
        return this.groupMember(this.gid());
    }

    @Override
    public boolean isIdentical(FileStat other) {
        this.handler.unimplementedError("identical file detection");
        return false;
    }

    @Override
    public boolean isNamedPipe() {
        this.handler.unimplementedError("piped file detection");
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.posix.geteuid() == this.uid();
    }

    @Override
    public boolean isROwned() {
        return this.posix.getuid() == this.uid();
    }

    @Override
    public boolean isReadable() {
        int mode = this.mode();
        if ((mode & 0x100) != 0) {
            return true;
        }
        if ((mode & 0x20) != 0) {
            return true;
        }
        return (mode & 4) != 0;
    }

    @Override
    public boolean isReadableReal() {
        return this.isReadable();
    }

    @Override
    public boolean isSymlink() {
        return (this.mode() & 0xA000) == 40960;
    }

    @Override
    public boolean isWritable() {
        int mode = this.mode();
        if ((mode & 0x80) != 0) {
            return true;
        }
        if ((mode & 0x10) != 0) {
            return true;
        }
        return (mode & 2) != 0;
    }

    @Override
    public boolean isWritableReal() {
        return this.isWritable();
    }

    @Override
    public boolean isSetgid() {
        this.handler.unimplementedError("setgid detection");
        return false;
    }

    @Override
    public boolean isSetuid() {
        this.handler.unimplementedError("setuid detection");
        return false;
    }

    @Override
    public boolean isSocket() {
        this.handler.unimplementedError("socket file type detection");
        return false;
    }

    @Override
    public boolean isSticky() {
        this.handler.unimplementedError("sticky bit detection");
        return false;
    }

    @Override
    public int major(long dev) {
        this.handler.unimplementedError("major device");
        return -1;
    }

    @Override
    public int minor(long dev) {
        this.handler.unimplementedError("minor device");
        return -1;
    }

    @Override
    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    @Override
    public long mtime() {
        return this.st_mtime;
    }

    @Override
    public int nlink() {
        this.handler.unimplementedError("stat.nlink");
        return -1;
    }

    @Override
    public long rdev() {
        this.handler.unimplementedError("stat.rdev");
        return -1L;
    }

    @Override
    public long st_size() {
        return this.st_size;
    }

    @Override
    public int uid() {
        return -1;
    }
}

