/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.org.antlr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.DFA;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.DFAOptimizer;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.DecisionProbe;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.NFAContext;
import org.openksavi.sponge.jython.shaded.org.antlr.analysis.NFAToDFAConverter;
import org.openksavi.sponge.jython.shaded.org.antlr.codegen.CodeGenerator;
import org.openksavi.sponge.jython.shaded.org.antlr.misc.Graph;
import org.openksavi.sponge.jython.shaded.org.antlr.runtime.misc.Stats;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.BuildDependencyGenerator;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.CompositeGrammar;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.DOTGenerator;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.ErrorManager;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Grammar;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.GrammarReport;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.GrammarReport2;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.GrammarSpelunker;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Rule;
import org.openksavi.sponge.jython.shaded.org.stringtemplate.v4.STGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tool {
    public final Properties antlrSettings = new Properties();
    public final String VERSION;
    public static final String UNINITIALIZED_DIR = "<unset-dir>";
    private List<String> grammarFileNames;
    private boolean generate_NFA_dot;
    private boolean generate_DFA_dot;
    private String outputDirectory;
    private boolean haveOutputDir;
    private String inputDirectory;
    private String parentGrammarDirectory;
    private String grammarOutputDirectory;
    private boolean haveInputDir;
    private String libDirectory;
    private boolean debug;
    private boolean trace;
    private boolean profile;
    private boolean report;
    private boolean printGrammar;
    private boolean depend;
    private boolean forceAllFilesToOutputDir;
    private boolean forceRelativeOutput;
    protected boolean deleteTempLexer;
    private boolean verbose;
    private boolean make;
    private boolean showBanner;
    private static boolean exitNow = false;
    private static boolean return_dont_exit = false;
    public String forcedLanguageOption;
    public static boolean internalOption_PrintGrammarTree = false;
    public static boolean internalOption_PrintDFA = false;
    public static boolean internalOption_ShowNFAConfigsInDFA = false;
    public static boolean internalOption_watchNFAConversion = false;

    public static void main(String[] args) {
        Tool antlr = new Tool(args);
        if (!exitNow) {
            antlr.process();
            if (return_dont_exit) {
                return;
            }
            if (ErrorManager.getNumErrors() > 0) {
                System.exit(1);
            }
            System.exit(0);
        }
    }

    private void loadResources() {
        InputStream in = this.getClass().getResourceAsStream("antlr.properties");
        if (in != null) {
            try {
                this.antlrSettings.load(in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Tool() {
        String version2 = Tool.class.getPackage().getImplementationVersion();
        this.VERSION = version2 != null ? version2 : "3.x";
        this.grammarFileNames = new ArrayList<String>();
        this.generate_NFA_dot = false;
        this.generate_DFA_dot = false;
        this.outputDirectory = ".";
        this.haveOutputDir = false;
        this.inputDirectory = null;
        this.haveInputDir = false;
        this.libDirectory = ".";
        this.debug = false;
        this.trace = false;
        this.profile = false;
        this.report = false;
        this.printGrammar = false;
        this.depend = false;
        this.forceAllFilesToOutputDir = false;
        this.forceRelativeOutput = false;
        this.deleteTempLexer = true;
        this.verbose = false;
        this.make = false;
        this.showBanner = true;
        this.loadResources();
    }

    public Tool(String[] args) {
        String version2 = Tool.class.getPackage().getImplementationVersion();
        this.VERSION = version2 != null ? version2 : "3.x";
        this.grammarFileNames = new ArrayList<String>();
        this.generate_NFA_dot = false;
        this.generate_DFA_dot = false;
        this.outputDirectory = ".";
        this.haveOutputDir = false;
        this.inputDirectory = null;
        this.haveInputDir = false;
        this.libDirectory = ".";
        this.debug = false;
        this.trace = false;
        this.profile = false;
        this.report = false;
        this.printGrammar = false;
        this.depend = false;
        this.forceAllFilesToOutputDir = false;
        this.forceRelativeOutput = false;
        this.deleteTempLexer = true;
        this.verbose = false;
        this.make = false;
        this.showBanner = true;
        this.loadResources();
        this.processArgs(args);
    }

    public void processArgs(String[] args) {
        if (this.isVerbose()) {
            ErrorManager.info("ANTLR Parser Generator  Version " + this.VERSION);
            this.showBanner = false;
        }
        if (args == null || args.length == 0) {
            Tool.help();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            File outDir;
            if (args[i].equals("-o") || args[i].equals("-fo")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing output directory with -fo/-o option; ignoring");
                    continue;
                }
                if (args[i].equals("-fo")) {
                    this.setForceAllFilesToOutputDir(true);
                }
                this.outputDirectory = args[++i];
                if (this.outputDirectory.endsWith("/") || this.outputDirectory.endsWith("\\")) {
                    this.outputDirectory = this.outputDirectory.substring(0, this.getOutputDirectory().length() - 1);
                }
                outDir = new File(this.outputDirectory);
                this.haveOutputDir = true;
                if (!outDir.exists() || outDir.isDirectory()) continue;
                ErrorManager.error(6, this.outputDirectory);
                this.setLibDirectory(".");
                continue;
            }
            if (args[i].equals("-lib")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing library directory with -lib option; ignoring");
                    continue;
                }
                this.setLibDirectory(args[++i]);
                if (this.getLibraryDirectory().endsWith("/") || this.getLibraryDirectory().endsWith("\\")) {
                    this.setLibDirectory(this.getLibraryDirectory().substring(0, this.getLibraryDirectory().length() - 1));
                }
                if ((outDir = new File(this.getLibraryDirectory())).exists()) continue;
                ErrorManager.error(5, this.getLibraryDirectory());
                this.setLibDirectory(".");
                continue;
            }
            if (args[i].equals("-language")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing language name; ignoring");
                    continue;
                }
                this.forcedLanguageOption = args[++i];
                continue;
            }
            if (args[i].equals("-nfa")) {
                this.setGenerate_NFA_dot(true);
                continue;
            }
            if (args[i].equals("-dfa")) {
                this.setGenerate_DFA_dot(true);
                continue;
            }
            if (args[i].equals("-debug")) {
                this.setDebug(true);
                continue;
            }
            if (args[i].equals("-trace")) {
                this.setTrace(true);
                continue;
            }
            if (args[i].equals("-report")) {
                this.setReport(true);
                continue;
            }
            if (args[i].equals("-profile")) {
                this.setProfile(true);
                continue;
            }
            if (args[i].equals("-print")) {
                this.setPrintGrammar(true);
                continue;
            }
            if (args[i].equals("-depend")) {
                this.setDepend(true);
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.setVerbose(true);
                continue;
            }
            if (args[i].equals("-version")) {
                Tool.version();
                exitNow = true;
                continue;
            }
            if (args[i].equals("-make")) {
                this.setMake(true);
                continue;
            }
            if (args[i].equals("-message-format")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing output format with -message-format option; using default");
                    continue;
                }
                ErrorManager.setFormat(args[++i]);
                continue;
            }
            if (args[i].equals("-Xgrtree")) {
                internalOption_PrintGrammarTree = true;
                continue;
            }
            if (args[i].equals("-Xdfa")) {
                internalOption_PrintDFA = true;
                continue;
            }
            if (args[i].equals("-Xnoprune")) {
                DFAOptimizer.PRUNE_EBNF_EXIT_BRANCHES = false;
                continue;
            }
            if (args[i].equals("-Xnocollapse")) {
                DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES = false;
                continue;
            }
            if (args[i].equals("-Xdbgconversion")) {
                NFAToDFAConverter.debug = true;
                continue;
            }
            if (args[i].equals("-Xmultithreaded")) {
                NFAToDFAConverter.SINGLE_THREADED_NFA_CONVERSION = false;
                continue;
            }
            if (args[i].equals("-Xnomergestopstates")) {
                DFAOptimizer.MERGE_STOP_STATES = false;
                continue;
            }
            if (args[i].equals("-Xdfaverbose")) {
                internalOption_ShowNFAConfigsInDFA = true;
                continue;
            }
            if (args[i].equals("-Xwatchconversion")) {
                internalOption_watchNFAConversion = true;
                continue;
            }
            if (args[i].equals("-XdbgST")) {
                CodeGenerator.LAUNCH_ST_INSPECTOR = true;
                STGroup.trackCreationEvents = true;
                return_dont_exit = true;
                continue;
            }
            if (args[i].equals("-Xmaxinlinedfastates")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max inline dfa states -Xmaxinlinedfastates option; ignoring");
                    continue;
                }
                CodeGenerator.MAX_ACYCLIC_DFA_STATES_INLINE = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-Xmaxswitchcaselabels")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max switch case labels -Xmaxswitchcaselabels option; ignoring");
                    continue;
                }
                CodeGenerator.MAX_SWITCH_CASE_LABELS = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-Xminswitchalts")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing min switch alternatives -Xminswitchalts option; ignoring");
                    continue;
                }
                CodeGenerator.MIN_SWITCH_ALTS = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-Xm")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max recursion with -Xm option; ignoring");
                    continue;
                }
                NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-Xmaxdfaedges")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max number of edges with -Xmaxdfaedges option; ignoring");
                    continue;
                }
                DFA.MAX_STATE_TRANSITIONS_FOR_TABLE = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-Xconversiontimeout")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max time in ms -Xconversiontimeout option; ignoring");
                    continue;
                }
                DFA.MAX_TIME_PER_DFA_CREATION = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-Xnfastates")) {
                DecisionProbe.verbose = true;
                continue;
            }
            if (args[i].equals("-Xsavelexer")) {
                this.deleteTempLexer = false;
                continue;
            }
            if (args[i].equals("-X")) {
                Tool.Xhelp();
                continue;
            }
            if (args[i].charAt(0) == '-') continue;
            this.addGrammarFile(args[i]);
        }
    }

    public boolean buildRequired(String grammarFileName) throws IOException {
        BuildDependencyGenerator bd = new BuildDependencyGenerator(this, grammarFileName);
        List<File> outputFiles = bd.getGeneratedFileList();
        List<File> inputFiles = bd.getDependenciesFileList();
        File grammarFile = this.haveInputDir ? new File(this.inputDirectory, grammarFileName) : new File(grammarFileName);
        long grammarLastModified = grammarFile.lastModified();
        for (File outputFile : outputFiles) {
            if (!outputFile.exists() || grammarLastModified > outputFile.lastModified()) {
                if (this.isVerbose()) {
                    if (!outputFile.exists()) {
                        System.out.println("Output file " + outputFile + " does not exist: must build " + grammarFile);
                    } else {
                        System.out.println("Output file " + outputFile + " is not up-to-date: must build " + grammarFile);
                    }
                }
                return true;
            }
            if (inputFiles == null) continue;
            for (File inputFile : inputFiles) {
                if (inputFile.lastModified() <= outputFile.lastModified()) continue;
                if (this.isVerbose()) {
                    System.out.println("Input file " + inputFile + " is newer than output: must rebuild " + grammarFile);
                }
                return true;
            }
        }
        if (this.isVerbose()) {
            System.out.println("Grammar " + grammarFile + " is up to date - build skipped");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        boolean exceptionWhenWritingLexerFile = false;
        if (this.isVerbose() && this.showBanner) {
            ErrorManager.info("ANTLR Parser Generator  Version " + this.VERSION);
            this.showBanner = false;
        }
        try {
            this.sortGrammarFiles();
        }
        catch (Exception e) {
            ErrorManager.error(10, e);
        }
        catch (Error e) {
            ErrorManager.error(10, e);
        }
        for (String grammarFileName : this.grammarFileNames) {
            if (this.make) {
                try {
                    if (!this.buildRequired(grammarFileName)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    ErrorManager.error(10, e);
                }
            }
            if (this.isVerbose() && !this.isDepend()) {
                System.out.println(grammarFileName);
            }
            try {
                Object greport;
                if (this.isDepend()) {
                    BuildDependencyGenerator dep = new BuildDependencyGenerator(this, grammarFileName);
                    System.out.println(dep.getDependencies().render());
                    continue;
                }
                Grammar rootGrammar = this.getRootGrammar(grammarFileName);
                rootGrammar.composite.assignTokenTypes();
                rootGrammar.addRulesForSyntacticPredicates();
                rootGrammar.composite.defineGrammarSymbols();
                rootGrammar.composite.createNFAs();
                this.generateRecognizer(rootGrammar);
                if (this.isPrintGrammar()) {
                    rootGrammar.printGrammar(System.out);
                }
                if (this.isReport()) {
                    greport = new GrammarReport2(rootGrammar);
                    System.out.print(((GrammarReport2)greport).toString());
                }
                if (this.isProfile()) {
                    greport = new GrammarReport(rootGrammar);
                    Stats.writeReport("grammar.stats", ((GrammarReport)greport).toNotifyString());
                }
                String lexerGrammarStr = rootGrammar.getLexerGrammar();
                if (rootGrammar.type != 4 || lexerGrammarStr == null) continue;
                String lexerGrammarFileName = rootGrammar.getImplicitlyGeneratedLexerFileName();
                try {
                    Writer w = this.getOutputFile(rootGrammar, lexerGrammarFileName);
                    w.write(lexerGrammarStr);
                    w.close();
                }
                catch (IOException e) {
                    exceptionWhenWritingLexerFile = true;
                    throw e;
                }
                try {
                    StringReader sr = new StringReader(lexerGrammarStr);
                    Grammar lexerGrammar = new Grammar(this);
                    lexerGrammar.composite.watchNFAConversion = internalOption_watchNFAConversion;
                    lexerGrammar.implicitLexer = true;
                    File lexerGrammarFullFile = new File(this.getFileDirectory(lexerGrammarFileName), lexerGrammarFileName);
                    lexerGrammar.setFileName(lexerGrammarFullFile.toString());
                    lexerGrammar.importTokenVocabulary(rootGrammar);
                    lexerGrammar.parseAndBuildAST(sr);
                    sr.close();
                    lexerGrammar.composite.assignTokenTypes();
                    lexerGrammar.addRulesForSyntacticPredicates();
                    lexerGrammar.composite.defineGrammarSymbols();
                    lexerGrammar.composite.createNFAs();
                    this.generateRecognizer(lexerGrammar);
                }
                finally {
                    if (!this.deleteTempLexer) continue;
                    File outputDir = this.getOutputDirectory(lexerGrammarFileName);
                    File outputFile = new File(outputDir, lexerGrammarFileName);
                    outputFile.delete();
                }
            }
            catch (IOException e) {
                if (exceptionWhenWritingLexerFile) {
                    ErrorManager.error(1, e);
                    continue;
                }
                ErrorManager.error(7, (Object)grammarFileName, e);
            }
            catch (Exception e) {
                ErrorManager.error(10, (Object)grammarFileName, e);
            }
        }
    }

    public void sortGrammarFiles() throws IOException {
        Graph<String> g = new Graph<String>();
        ArrayList<String> missingFiles = new ArrayList<String>();
        for (String gfile : this.grammarFileNames) {
            try {
                GrammarSpelunker grammar2 = new GrammarSpelunker(this.inputDirectory, gfile);
                grammar2.parse();
                String vocabName = grammar2.getTokenVocab();
                String grammarName = grammar2.getGrammarName();
                if (vocabName != null) {
                    g.addEdge(gfile, vocabName + ".tokens");
                }
                g.addEdge(grammarName + ".tokens", gfile);
            }
            catch (FileNotFoundException fnfe) {
                ErrorManager.error(7, (Object)gfile, fnfe);
                missingFiles.add(gfile);
            }
        }
        List sorted = g.sort();
        this.grammarFileNames.clear();
        for (int i = 0; i < sorted.size(); ++i) {
            String f = (String)sorted.get(i);
            if (missingFiles.contains(f) || !f.endsWith(".g") && !f.endsWith(".g3")) continue;
            this.grammarFileNames.add(f);
        }
    }

    public Grammar getRootGrammar(String grammarFileName) throws IOException {
        CompositeGrammar composite = new CompositeGrammar();
        Grammar grammar2 = new Grammar(this, grammarFileName, composite);
        composite.setDelegationRoot(grammar2);
        File f = this.haveInputDir ? new File(this.inputDirectory, grammarFileName) : new File(grammarFileName);
        this.parentGrammarDirectory = f.getParent();
        this.grammarOutputDirectory = grammarFileName.lastIndexOf(File.separatorChar) == -1 ? "." : grammarFileName.substring(0, grammarFileName.lastIndexOf(File.separatorChar));
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        grammar2.parseAndBuildAST(br);
        composite.watchNFAConversion = internalOption_watchNFAConversion;
        br.close();
        fr.close();
        return grammar2;
    }

    protected void generateRecognizer(Grammar grammar2) {
        String language = (String)grammar2.getOption("language");
        if (language != null) {
            CodeGenerator generator2 = new CodeGenerator(this, grammar2, language);
            grammar2.setCodeGenerator(generator2);
            generator2.setDebug(this.isDebug());
            generator2.setProfile(this.isProfile());
            generator2.setTrace(this.isTrace());
            if (this.isGenerate_NFA_dot()) {
                this.generateNFAs(grammar2);
            }
            generator2.genRecognizer();
            if (this.isGenerate_DFA_dot()) {
                this.generateDFAs(grammar2);
            }
            List<Grammar> delegates = grammar2.getDirectDelegates();
            for (int i = 0; delegates != null && i < delegates.size(); ++i) {
                Grammar delegate = delegates.get(i);
                if (delegate == grammar2) continue;
                this.generateRecognizer(delegate);
            }
        }
    }

    public void generateDFAs(Grammar g) {
        for (int d = 1; d <= g.getNumberOfDecisions(); ++d) {
            DFA dfa = g.getLookaheadDFA(d);
            if (dfa == null) continue;
            DOTGenerator dotGenerator = new DOTGenerator(g);
            String dot = dotGenerator.getDOT(dfa.startState);
            String dotFileName = g.name + "." + "dec-" + d;
            if (g.implicitLexer) {
                dotFileName = g.name + Grammar.grammarTypeToFileNameSuffix[g.type] + "." + "dec-" + d;
            }
            try {
                this.writeDOTFile(g, dotFileName, dot);
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.error(14, (Object)dotFileName, ioe);
            }
        }
    }

    protected void generateNFAs(Grammar g) {
        DOTGenerator dotGenerator = new DOTGenerator(g);
        HashSet<? extends Rule> rules = new HashSet<Rule>(g.getAllImportedRules());
        rules.addAll(g.getRules());
        for (Rule rule : rules) {
            try {
                String dot = dotGenerator.getDOT(rule.startState);
                if (dot == null) continue;
                this.writeDOTFile(g, rule, dot);
            }
            catch (IOException ioe) {
                ErrorManager.error(1, ioe);
            }
        }
    }

    protected void writeDOTFile(Grammar g, Rule r, String dot) throws IOException {
        this.writeDOTFile(g, r.grammar.name + "." + r.name, dot);
    }

    protected void writeDOTFile(Grammar g, String name, String dot) throws IOException {
        Writer fw = this.getOutputFile(g, name + ".dot");
        fw.write(dot);
        fw.close();
    }

    private static void version() {
        ErrorManager.info("ANTLR Parser Generator  Version " + new Tool().VERSION);
    }

    private static void help() {
        ErrorManager.info("ANTLR Parser Generator  Version " + new Tool().VERSION);
        System.err.println("usage: java org.antlr.Tool [args] file.g [file2.g file3.g ...]");
        System.err.println("  -o outputDir          specify output directory where all output is generated");
        System.err.println("  -fo outputDir         same as -o but force even files with relative paths to dir");
        System.err.println("  -lib dir              specify location of token files");
        System.err.println("  -depend               generate file dependencies");
        System.err.println("  -report               print out a report about the grammar(s) processed");
        System.err.println("  -print                print out the grammar without actions");
        System.err.println("  -debug                generate a parser that emits debugging events");
        System.err.println("  -profile              generate a parser that computes profiling information");
        System.err.println("  -trace                generate a recognizer that traces rule entry/exit");
        System.err.println("  -nfa                  generate an NFA for each rule");
        System.err.println("  -dfa                  generate a DFA for each decision point");
        System.err.println("  -message-format name  specify output style for messages");
        System.err.println("  -verbose              generate ANTLR version and other information");
        System.err.println("  -make                 only build if generated files older than grammar");
        System.err.println("  -version              print the version of ANTLR and exit.");
        System.err.println("  -language L           override language grammar option; generate L");
        System.err.println("  -X                    display extended argument list");
    }

    private static void Xhelp() {
        ErrorManager.info("ANTLR Parser Generator  Version " + new Tool().VERSION);
        System.err.println("  -Xgrtree                print the grammar AST");
        System.err.println("  -Xdfa                   print DFA as text ");
        System.err.println("  -Xnoprune               test lookahead against EBNF block exit branches");
        System.err.println("  -Xnocollapse            collapse incident edges into DFA states");
        System.err.println("  -Xdbgconversion         dump lots of info during NFA conversion");
        System.err.println("  -Xconversiontimeout     use to restrict NFA conversion exponentiality");
        System.err.println("  -Xmultithreaded         run the analysis in 2 threads");
        System.err.println("  -Xnomergestopstates     do not merge stop states");
        System.err.println("  -Xdfaverbose            generate DFA states in DOT with NFA configs");
        System.err.println("  -Xwatchconversion       print a message for each NFA before converting");
        System.err.println("  -XdbgST                 put tags at start/stop of all templates in output");
        System.err.println("  -Xnfastates             for nondeterminisms, list NFA states for each path");
        System.err.println("  -Xm m                   max number of rule invocations during conversion           [" + NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK + "]");
        System.err.println("  -Xmaxdfaedges m         max \"comfortable\" number of edges for single DFA state     [" + DFA.MAX_STATE_TRANSITIONS_FOR_TABLE + "]");
        System.err.println("  -Xmaxinlinedfastates m  max DFA states before table used rather than inlining      [60]");
        System.err.println("  -Xmaxswitchcaselabels m don't generate switch() statements for dfas bigger  than m [300]");
        System.err.println("  -Xminswitchalts m       don't generate switch() statements for dfas smaller than m [3]");
        System.err.println("  -Xsavelexer             don't delete temporary lexers generated from combined grammars");
    }

    public void setMaxSwitchCaseLabels(int maxSwitchCaseLabels) {
        CodeGenerator.MAX_SWITCH_CASE_LABELS = maxSwitchCaseLabels;
    }

    public void setMinSwitchAlts(int minSwitchAlts) {
        CodeGenerator.MIN_SWITCH_ALTS = minSwitchAlts;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.haveOutputDir = true;
        this.outputDirectory = outputDirectory;
    }

    public void setForceRelativeOutput(boolean forceRelativeOutput) {
        this.forceRelativeOutput = forceRelativeOutput;
    }

    public void setInputDirectory(String inputDirectory) {
        this.inputDirectory = inputDirectory;
        this.haveInputDir = true;
    }

    public Writer getOutputFile(Grammar g, String fileName) throws IOException {
        if (this.getOutputDirectory() == null) {
            return new StringWriter();
        }
        File outputDir = fileName.endsWith(".tokens") ? (this.haveOutputDir ? new File(this.getOutputDirectory()) : new File(".")) : this.getOutputDirectory(g.getFileName());
        File outputFile = new File(outputDir, fileName);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        FileWriter fw = new FileWriter(outputFile);
        return new BufferedWriter(fw);
    }

    public File getOutputDirectory(String fileNameWithPath) {
        String fileDirectory = fileNameWithPath.lastIndexOf(File.separatorChar) == -1 ? this.grammarOutputDirectory : fileNameWithPath.substring(0, fileNameWithPath.lastIndexOf(File.separatorChar));
        File outputDir = this.haveOutputDir ? (fileDirectory != null && !this.forceRelativeOutput && (new File(fileDirectory).isAbsolute() || fileDirectory.startsWith("~")) || this.isForceAllFilesToOutputDir() ? new File(this.getOutputDirectory()) : (fileDirectory != null ? new File(this.getOutputDirectory(), fileDirectory) : new File(this.getOutputDirectory()))) : new File(fileDirectory);
        return outputDir;
    }

    public String getLibraryFile(String fileName) throws IOException {
        File f = new File(this.getLibraryDirectory() + File.separator + fileName);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return this.parentGrammarDirectory + File.separator + fileName;
    }

    public String getFileDirectory(String fileName) {
        File f = this.haveInputDir && !fileName.startsWith(File.separator) ? new File(this.inputDirectory, fileName) : new File(fileName);
        return f.getParent();
    }

    public File getImportedVocabFile(String vocabName) {
        File f = new File(this.getLibraryDirectory(), File.separator + vocabName + ".tokens");
        if (f.exists()) {
            return f;
        }
        f = this.haveOutputDir ? new File(this.getOutputDirectory(), vocabName + ".tokens") : new File(vocabName + ".tokens");
        return f;
    }

    public void panic() {
        throw new Error("ANTLR panic");
    }

    public static String getCurrentTimeStamp() {
        GregorianCalendar calendar2 = new GregorianCalendar();
        int y = calendar2.get(1);
        int m = calendar2.get(2) + 1;
        int d = calendar2.get(5);
        int h = calendar2.get(11);
        int min = calendar2.get(12);
        int sec = calendar2.get(13);
        String sy = String.valueOf(y);
        String sm = m < 10 ? "0" + m : String.valueOf(m);
        String sd = d < 10 ? "0" + d : String.valueOf(d);
        String sh = h < 10 ? "0" + h : String.valueOf(h);
        String smin = min < 10 ? "0" + min : String.valueOf(min);
        String ssec = sec < 10 ? "0" + sec : String.valueOf(sec);
        return new StringBuffer().append(sy).append("-").append(sm).append("-").append(sd).append(" ").append(sh).append(":").append(smin).append(":").append(ssec).toString();
    }

    public List<String> getGrammarFileNames() {
        return this.grammarFileNames;
    }

    public boolean isGenerate_NFA_dot() {
        return this.generate_NFA_dot;
    }

    public boolean isGenerate_DFA_dot() {
        return this.generate_DFA_dot;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getLibraryDirectory() {
        return this.libDirectory;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isReport() {
        return this.report;
    }

    public boolean isPrintGrammar() {
        return this.printGrammar;
    }

    public boolean isDepend() {
        return this.depend;
    }

    public boolean isForceAllFilesToOutputDir() {
        return this.forceAllFilesToOutputDir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getConversionTimeout() {
        return DFA.MAX_TIME_PER_DFA_CREATION;
    }

    public String getMessageFormat() {
        return ErrorManager.getMessageFormat().toString();
    }

    public int getNumErrors() {
        return ErrorManager.getNumErrors();
    }

    public boolean getMake() {
        return this.make;
    }

    public void setMessageFormat(String format) {
        ErrorManager.setFormat(format);
    }

    public void setGrammarFileNames(List<String> grammarFileNames) {
        this.grammarFileNames = grammarFileNames;
    }

    public void addGrammarFile(String grammarFileName) {
        if (!this.grammarFileNames.contains(grammarFileName)) {
            this.grammarFileNames.add(grammarFileName);
        }
    }

    public void setGenerate_NFA_dot(boolean generate_NFA_dot) {
        this.generate_NFA_dot = generate_NFA_dot;
    }

    public void setGenerate_DFA_dot(boolean generate_DFA_dot) {
        this.generate_DFA_dot = generate_DFA_dot;
    }

    public void setLibDirectory(String libDirectory) {
        this.libDirectory = libDirectory;
    }

    public void setDebug(boolean debug2) {
        this.debug = debug2;
    }

    public void setTrace(boolean trace2) {
        this.trace = trace2;
    }

    public void setProfile(boolean profile2) {
        this.profile = profile2;
    }

    public void setReport(boolean report) {
        this.report = report;
    }

    public void setPrintGrammar(boolean printGrammar) {
        this.printGrammar = printGrammar;
    }

    public void setDepend(boolean depend) {
        this.depend = depend;
    }

    public void setForceAllFilesToOutputDir(boolean forceAllFilesToOutputDir) {
        this.forceAllFilesToOutputDir = forceAllFilesToOutputDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMake(boolean make) {
        this.make = make;
    }
}

