/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.midi.event;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.midi.event.MidiMessageEvent;

public class MidiMetaMessageEvent
extends MidiMessageEvent<MetaMessage> {
    private static final long serialVersionUID = -8321799970247326821L;
    public static final String ATTR_MESSAGE_TYPE = "messageType";
    public static final String ATTR_DATA = "data";

    public MidiMetaMessageEvent(String name, EventClonePolicy clonePolicy, MetaMessage message, Long timeStamp) {
        super(name, clonePolicy, message, timeStamp);
    }

    public MidiMetaMessageEvent(String name, EventClonePolicy clonePolicy, MetaMessage message) {
        this(name, clonePolicy, message, (Long)null);
    }

    public int getMessageType() {
        return ((MetaMessage)this.getMessage()).getType();
    }

    public void setMessageType(int type) {
        try {
            ((MetaMessage)this.getMessage()).setMessage(type, this.getData(), this.getData().length);
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public byte[] getData() {
        return ((MetaMessage)this.getMessage()).getData();
    }

    public void setData(byte[] data) {
        try {
            ((MetaMessage)this.getMessage()).setMessage(this.getMessageType(), data, data.length);
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    @Override
    public <T> T doGet(String name, boolean useDefault, T defaultValue) {
        Object result;
        switch (name) {
            case "messageType": {
                result = this.getMessageType();
                break;
            }
            case "data": {
                result = this.getData();
                break;
            }
            default: {
                result = super.doGet(name, useDefault, defaultValue);
            }
        }
        return (T)result;
    }

    public MidiMetaMessageEvent set(String name, Object value) {
        switch (name) {
            case "messageType": {
                this.setMessageType(SpongeUtils.toInt((Object)value));
                break;
            }
            case "data": {
                this.setData((byte[])value);
                break;
            }
            default: {
                super.set(name, value);
            }
        }
        return this;
    }

    @Override
    public boolean has(String name) {
        return ATTR_MESSAGE_TYPE.equals(name) || ATTR_DATA.equals(name) || super.has(name);
    }

    @Override
    public Map<String, Object> getAll() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(ATTR_MESSAGE_TYPE, this.getMessageType());
        result.put(ATTR_DATA, Hex.encodeHex((byte[])this.getData()));
        result.putAll(super.getAll());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public MidiMessageEvent.Category getCategory() {
        return MidiMessageEvent.Category.META;
    }

    @Override
    public String getMessageString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("category", (Object)this.getCategory().getCode()).append(ATTR_MESSAGE_TYPE, this.getMessageType()).append(ATTR_DATA, Hex.encodeHex((byte[])this.getData())).append("timeStamp", (Object)this.getTimeStamp()).toString();
    }
}

