/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.midi;

import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.midi.MidiPlugin;
import org.openksavi.sponge.midi.MidiUtils;
import org.openksavi.sponge.midi.event.MidiMessageEvent;
import org.openksavi.sponge.midi.event.MidiMetaMessageEvent;
import org.openksavi.sponge.midi.event.MidiSysexMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidiSpongeEventReceiver
implements Receiver {
    private static final Logger logger = LoggerFactory.getLogger(MidiSpongeEventReceiver.class);
    private MidiPlugin midiPlugin;
    private boolean sound = false;

    public MidiSpongeEventReceiver(MidiPlugin midiPlugin) {
        this.midiPlugin = midiPlugin;
    }

    public MidiSpongeEventReceiver(MidiPlugin midiPlugin, boolean sound) {
        this(midiPlugin);
        this.sound = sound;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        try {
            MidiMessageEvent event;
            if (this.sound) {
                this.midiPlugin.sound(message);
            }
            if (message instanceof ShortMessage) {
                event = MidiUtils.createShortMessageEvent(this.midiPlugin, (ShortMessage)message, timeStamp);
            } else if (message instanceof SysexMessage) {
                event = new MidiSysexMessageEvent(this.midiPlugin.getMidiSysexMessageEventName(), this.midiPlugin.getEngine().getDefaultParameters().getEventClonePolicy(), (SysexMessage)message, (Long)timeStamp);
            } else if (message instanceof MetaMessage) {
                event = new MidiMetaMessageEvent(this.midiPlugin.getMidiMetaMessageEventName(), this.midiPlugin.getEngine().getDefaultParameters().getEventClonePolicy(), (MetaMessage)message, (Long)timeStamp);
            } else {
                throw new SpongeException("Unknown MIDI message type: " + message.getClass());
            }
            this.midiPlugin.getEngine().getOperations().event((Event)event).send();
        }
        catch (Exception e) {
            logger.error("send", (Throwable)e);
        }
    }

    @Override
    public void close() {
    }
}

