/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.midi.event;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.midi.event.MidiMessageEvent;

public class MidiShortMessageEvent
extends MidiMessageEvent<ShortMessage> {
    private static final long serialVersionUID = -5881083348610116349L;
    public static final String ATTR_COMMAND = "command";
    public static final String ATTR_CHANNEL = "channel";
    public static final String ATTR_DATA1 = "data1";
    public static final String ATTR_DATA2 = "data2";

    public MidiShortMessageEvent(String name, EventClonePolicy clonePolicy, ShortMessage message, Long timeStamp) {
        super(name, clonePolicy, message, timeStamp);
    }

    public MidiShortMessageEvent(String name, EventClonePolicy clonePolicy, ShortMessage message) {
        this(name, clonePolicy, message, (Long)null);
    }

    public int getCommand() {
        return ((ShortMessage)this.getMessage()).getCommand();
    }

    public void setCommand(int command) {
        try {
            ((ShortMessage)this.getMessage()).setMessage(command, this.getChannel(), this.getData1(), this.getData2());
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public int getChannel() {
        return ((ShortMessage)this.getMessage()).getChannel();
    }

    public void setChannel(int channel) {
        try {
            ((ShortMessage)this.getMessage()).setMessage(this.getCommand(), channel, this.getData1(), this.getData2());
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public int getData1() {
        return ((ShortMessage)this.getMessage()).getData1();
    }

    public void setData1(int data1) {
        try {
            ((ShortMessage)this.getMessage()).setMessage(this.getCommand(), this.getChannel(), data1, this.getData2());
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public int getData2() {
        return ((ShortMessage)this.getMessage()).getData2();
    }

    public void setData2(int data2) {
        try {
            ((ShortMessage)this.getMessage()).setMessage(this.getCommand(), this.getChannel(), this.getData1(), data2);
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    @Override
    public <T> T doGet(String name, boolean useDefault, T defaultValue) {
        Integer result;
        switch (name) {
            case "command": {
                result = this.getCommand();
                break;
            }
            case "channel": {
                result = this.getChannel();
                break;
            }
            case "data1": {
                result = this.getData1();
                break;
            }
            case "data2": {
                result = this.getData2();
                break;
            }
            default: {
                result = super.doGet(name, useDefault, defaultValue);
            }
        }
        return (T)result;
    }

    public MidiShortMessageEvent set(String name, Object value) {
        switch (name) {
            case "command": {
                this.setCommand(SpongeUtils.toInt((Object)value));
                break;
            }
            case "channel": {
                this.setChannel(SpongeUtils.toInt((Object)value));
                break;
            }
            case "data1": {
                this.setData1(SpongeUtils.toInt((Object)value));
                break;
            }
            case "data2": {
                this.setData2(SpongeUtils.toInt((Object)value));
                break;
            }
            default: {
                super.set(name, value);
            }
        }
        return this;
    }

    @Override
    public boolean has(String name) {
        return ATTR_COMMAND.equals(name) || ATTR_CHANNEL.equals(name) || ATTR_DATA1.equals(name) || ATTR_DATA2.equals(name) || super.has(name);
    }

    @Override
    public Map<String, Object> getAll() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(ATTR_COMMAND, this.getCommand());
        result.put(ATTR_CHANNEL, this.getChannel());
        result.put(ATTR_DATA1, this.getData1());
        result.put(ATTR_DATA2, this.getData2());
        result.putAll(super.getAll());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public MidiMessageEvent.MidiEventCategory getMidiCategory() {
        return MidiMessageEvent.MidiEventCategory.SHORT;
    }

    @Override
    public String getMessageString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("category", (Object)this.getMidiCategory().getCode()).append(ATTR_COMMAND, this.getCommand()).append(ATTR_CHANNEL, this.getChannel()).append(ATTR_DATA1, this.getData1()).append(ATTR_DATA2, this.getData2()).append("timeStamp", (Object)this.getTimeStamp()).toString();
    }
}

