/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.midi.event;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.SysexMessage;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.midi.event.MidiMessageEvent;

public class MidiSysexMessageEvent
extends MidiMessageEvent<SysexMessage> {
    private static final long serialVersionUID = 3060906955262924451L;
    public static final String ATTR_DATA = "data";

    public MidiSysexMessageEvent(String name, EventClonePolicy clonePolicy, SysexMessage message, Long timeStamp) {
        super(name, clonePolicy, message, timeStamp);
    }

    public MidiSysexMessageEvent(String name, EventClonePolicy clonePolicy, SysexMessage message) {
        this(name, clonePolicy, message, (Long)null);
    }

    public byte[] getData() {
        return ((SysexMessage)this.getMessage()).getData();
    }

    public void setData(byte[] data) {
        try {
            ((SysexMessage)this.getMessage()).setMessage(data, data.length);
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    @Override
    public <T> T doGet(String name, boolean useDefault, T defaultValue) {
        switch (name) {
            case "data": {
                return (T)this.getData();
            }
        }
        return super.doGet(name, useDefault, defaultValue);
    }

    public MidiSysexMessageEvent set(String name, Object value) {
        switch (name) {
            case "data": {
                this.setData((byte[])value);
                break;
            }
            default: {
                super.set(name, value);
            }
        }
        return this;
    }

    @Override
    public boolean has(String name) {
        return ATTR_DATA.equals(name) || super.has(name);
    }

    @Override
    public Map<String, Object> getAll() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(ATTR_DATA, this.getData());
        result.putAll(super.getAll());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public MidiMessageEvent.MidiEventCategory getMidiCategory() {
        return MidiMessageEvent.MidiEventCategory.SYSEX;
    }

    @Override
    public String getMessageString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("category", (Object)this.getMidiCategory().getCode()).append(ATTR_DATA, Hex.encodeHex((byte[])this.getData())).append("timeStamp", (Object)this.getTimeStamp()).toString();
    }
}

