/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.midi.event;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.midi.MidiMessage;
import org.openksavi.sponge.core.event.BaseEvent;
import org.openksavi.sponge.event.EventClonePolicy;

public abstract class MidiMessageEvent<M extends MidiMessage>
extends BaseEvent {
    private static final long serialVersionUID = 4119731368862161071L;
    public static final String ATTR_MESSAGE = "message";
    public static final String ATTR_TIME_STAMP = "timeStamp";
    private M message;
    private Long timeStamp;

    public MidiMessageEvent(String name, EventClonePolicy clonePolicy, M message, Long timeStamp) {
        super(name, clonePolicy);
        this.message = message;
        this.timeStamp = timeStamp;
    }

    public MidiMessageEvent(String name, EventClonePolicy clonePolicy, M message) {
        this(name, clonePolicy, message, null);
    }

    public M getMessage() {
        return this.message;
    }

    public void setMessage(M message) {
        this.message = message;
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public <T> T doGet(String name, boolean useDefault, T defaultValue) {
        Object result;
        switch (name) {
            case "message": {
                result = this.message;
                break;
            }
            case "timeStamp": {
                result = this.timeStamp;
                break;
            }
            default: {
                return (T)this.getDefaultAttributeValue(name, useDefault, defaultValue);
            }
        }
        return (T)result;
    }

    public MidiMessageEvent<M> set(String name, Object value) {
        switch (name) {
            case "message": {
                this.message = (MidiMessage)value;
                break;
            }
            case "timeStamp": {
                this.timeStamp = (Long)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attribute " + name);
            }
        }
        return this;
    }

    public boolean has(String name) {
        return ATTR_MESSAGE.equals(name) || ATTR_TIME_STAMP.equals(name);
    }

    public Map<String, Object> getAll() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(ATTR_MESSAGE, this.message);
        result.put(ATTR_TIME_STAMP, this.timeStamp);
        return Collections.unmodifiableMap(result);
    }

    public abstract MidiEventCategory getMidiCategory();

    public abstract String getMessageString();

    public static enum MidiEventCategory {
        SHORT("short"),
        META("meta"),
        SYSEX("sysex");

        private String code;

        private MidiEventCategory(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

