/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.midi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JPlugin;
import org.openksavi.sponge.midi.MidiSpongeEventReceiver;
import org.openksavi.sponge.midi.MidiUtils;
import org.openksavi.sponge.midi.event.MidiMetaMessageEvent;
import org.openksavi.sponge.midi.event.MidiShortMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidiPlugin
extends JPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MidiPlugin.class);
    public static final String DEFAULT_PLUGIN_NAME = "midi";
    private Sequencer sequencer;
    private Transmitter sequencerTransmitter;
    private Synthesizer synthesizer;
    private Receiver synthesizerReceiver;
    private MidiDevice inputDevice;
    private Transmitter inputTransmitter;
    private boolean sequencerConnectedToSynthesizer = false;
    private boolean loadAllInstruments = true;
    private String midiShortMessageEventName = "midiShort";
    private String midiSysexMessageEventName = "midiSysex";
    private String midiMetaMessageEventName = "midiMeta";
    private Lock lock = new ReentrantLock(true);

    public MidiPlugin() {
        this.setName(DEFAULT_PLUGIN_NAME);
    }

    public MidiPlugin(String name) {
        super(name);
    }

    public void onConfigure(Configuration configuration) {
        this.sequencerConnectedToSynthesizer = configuration.getBoolean("sequencerConnectedToSynthesizer", Boolean.valueOf(this.sequencerConnectedToSynthesizer));
        this.loadAllInstruments = configuration.getBoolean("loadAllInstruments", Boolean.valueOf(this.loadAllInstruments));
        this.midiShortMessageEventName = configuration.getString("midiShortMessageEventName", this.midiShortMessageEventName);
        this.midiSysexMessageEventName = configuration.getString("midiSysexMessageEventName", this.midiSysexMessageEventName);
        this.midiMetaMessageEventName = configuration.getString("midiMetaMessageEventName", this.midiMetaMessageEventName);
    }

    public void onStartup() {
        try {
            this.logMidiSystemInfo();
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer(this.sequencerConnectedToSynthesizer);
                if (this.sequencer == null) {
                    throw new SpongeException("The sequencer device is not supported");
                }
            }
            if (this.synthesizer == null) {
                this.synthesizer = MidiSystem.getSynthesizer();
                if (this.synthesizer == null) {
                    throw new SpongeException("The synthesizer device is not supported");
                }
            }
            this.update();
            if (this.loadAllInstruments) {
                this.loadAllInstruments();
            }
        }
        catch (MidiUnavailableException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public void update() {
        this.updateSequencer();
        this.updateSynthesizer();
        this.updateInputDevice();
    }

    public void updateSequencer() {
        this.lock.lock();
        try {
            MidiUtils.open(this.sequencer);
            MidiUtils.close(this.sequencerTransmitter);
            if (this.sequencer != null) {
                this.sequencerTransmitter = this.sequencer.getTransmitter();
                this.sequencerTransmitter.setReceiver(new MidiSpongeEventReceiver(this));
                this.sequencer.addMetaEventListener(message -> this.getEngine().getOperations().event((Event)new MidiMetaMessageEvent(this.getMidiMetaMessageEventName(), this.getEngine().getDefaultParameters().getEventClonePolicy(), message)).send());
            }
        }
        catch (MidiUnavailableException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateSynthesizer() {
        this.lock.lock();
        try {
            MidiUtils.open(this.synthesizer);
            MidiUtils.close(this.synthesizerReceiver);
            if (this.synthesizer != null) {
                this.synthesizerReceiver = this.synthesizer.getReceiver();
            }
        }
        catch (MidiUnavailableException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateInputDevice() {
        this.lock.lock();
        try {
            MidiUtils.open(this.inputDevice);
            MidiUtils.close(this.inputTransmitter);
            if (this.inputDevice != null) {
                this.inputTransmitter = this.inputDevice.getTransmitter();
                this.inputTransmitter.setReceiver(new MidiSpongeEventReceiver(this));
            }
        }
        catch (MidiUnavailableException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onShutdown() {
        MidiUtils.close(this.sequencer);
        MidiUtils.close(this.synthesizer);
        MidiUtils.close(this.inputDevice);
    }

    public void connectInputDevice(String deviceName) {
        MidiDevice device = this.getDeviceByName(deviceName);
        if (device == null) {
            throw new SpongeException("MIDI device named '" + deviceName + "' not found");
        }
        this.setInputDevice(device);
        this.updateInputDevice();
    }

    public void connectDefaultInputDevice() {
        MidiDevice device = MidiUtils.getDefaultInputDevice();
        if (device == null) {
            throw new SpongeException("No default input MIDI device found");
        }
        this.setInputDevice(device);
        this.updateInputDevice();
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public void setSequencer(Sequencer sequencer) {
        if (sequencer != this.sequencer) {
            MidiUtils.close(this.sequencer);
        }
        this.sequencer = sequencer;
    }

    public Synthesizer getSynthesizer() {
        return this.synthesizer;
    }

    public void setSynthesizer(Synthesizer synthesizer) {
        if (synthesizer != this.synthesizer) {
            MidiUtils.close(this.synthesizer);
        }
        this.synthesizer = synthesizer;
    }

    public MidiDevice getInputDevice() {
        return this.inputDevice;
    }

    public void setInputDevice(MidiDevice inputDevice) {
        if (inputDevice != this.inputDevice) {
            MidiUtils.close(this.inputDevice);
        }
        this.inputDevice = inputDevice;
    }

    public Receiver getSynthesizerReceiver() {
        return this.synthesizerReceiver;
    }

    public Transmitter getInputTransmitter() {
        return this.inputTransmitter;
    }

    public Transmitter getSequencerTransmitter() {
        return this.sequencerTransmitter;
    }

    public boolean isSequencerConnectedToSynthesizer() {
        return this.sequencerConnectedToSynthesizer;
    }

    public void setSequencerConnectedToSynthesizer(boolean sequencerConnectedToSynthesizer) {
        this.sequencerConnectedToSynthesizer = sequencerConnectedToSynthesizer;
    }

    public boolean isLoadAllInstruments() {
        return this.loadAllInstruments;
    }

    public void setLoadAllInstruments(boolean loadAllInstruments) {
        this.loadAllInstruments = loadAllInstruments;
    }

    public String getMidiShortMessageEventName() {
        return this.midiShortMessageEventName;
    }

    public void setMidiShortMessageEventName(String midiShortMessageEventName) {
        this.midiShortMessageEventName = midiShortMessageEventName;
    }

    public String getMidiSysexMessageEventName() {
        return this.midiSysexMessageEventName;
    }

    public void setMidiSysexMessageEventName(String midiSysexMessageEventName) {
        this.midiSysexMessageEventName = midiSysexMessageEventName;
    }

    public String getMidiMetaMessageEventName() {
        return this.midiMetaMessageEventName;
    }

    public void setMidiMetaMessageEventName(String midiMetaMessageEventName) {
        this.midiMetaMessageEventName = midiMetaMessageEventName;
    }

    public void sound(MidiMessage message) {
        this.sound(message, -1L);
    }

    public void sound(MidiMessage message, long timeStamp) {
        this.synthesizerReceiver.send(message, timeStamp);
    }

    public void sound(int command, int channel, int data1, int data2) {
        this.sound(this.createShortMessage(command, channel, data1, data2));
    }

    public void noteOn(int channel, int data1, int data2) {
        this.sound(this.createShortMessage(144, channel, data1, data2));
    }

    public void noteOff(int channel, int data1, int data2) {
        this.sound(this.createShortMessage(128, channel, data1, data2));
    }

    public void startPlay(String midiFileName) {
        this.startPlay(new File(midiFileName));
    }

    public void startPlay(File midiFile) {
        try {
            this.startPlay(MidiSystem.getSequence(midiFile));
        }
        catch (IOException | InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public void startPlay(InputStream stream) {
        try {
            this.startPlay(MidiSystem.getSequence(stream));
        }
        catch (IOException | InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public void startPlay(URL url) {
        try {
            this.startPlay(MidiSystem.getSequence(url));
        }
        catch (IOException | InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public void startPlay(Sequence sequence) {
        try {
            this.sequencer.setSequence(sequence);
        }
        catch (InvalidMidiDataException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        this.sequencer.start();
    }

    public void stopPlay() {
        this.sequencer.stop();
    }

    public ShortMessage createShortMessage(int command, int channel, int data1, int data2) {
        return MidiUtils.createShortMessage(command, channel, data1, data2);
    }

    public MidiShortMessageEvent createShortMessageEvent(ShortMessage message, long timeStamp) {
        return MidiUtils.createShortMessageEvent(this, message, timeStamp);
    }

    public MidiShortMessageEvent createShortMessageEvent(ShortMessage message) {
        return MidiUtils.createShortMessageEvent(this, message);
    }

    public boolean loadAllInstruments() {
        return MidiUtils.loadAllInstruments(this.synthesizer);
    }

    public Instrument setInstrument(int channel, int instrument) {
        return MidiUtils.setInstrument(this.synthesizer, channel, instrument);
    }

    public Instrument setInstrument(int channel, String instrumentName) {
        return MidiUtils.setInstrument(this.synthesizer, channel, instrumentName);
    }

    public List<Instrument> getInstruments() {
        return MidiUtils.getInstruments(this.synthesizer);
    }

    public Instrument getInstrument(int channel) {
        return MidiUtils.getInstrument(this.synthesizer, channel);
    }

    public List<MidiChannel> getChannels() {
        return Arrays.asList(this.synthesizer.getChannels());
    }

    public List<MidiDevice> getDevices() {
        return MidiUtils.getDevices();
    }

    public MidiDevice getDefaultInputDevice() {
        return MidiUtils.getDefaultInputDevice();
    }

    public MidiDevice getDeviceByName(String name) {
        return MidiUtils.getDeviceByName(name);
    }

    public void logMidiSystemInfo() {
        this.getDevices().forEach(device -> logger.info("Device: name={}, class={}, description={}, vendor={}, version={}, microsecondPosition={}, maxTransmitters={}, maxReceivers={}", new Object[]{device.getDeviceInfo().getName(), device.getClass().getSimpleName(), device.getDeviceInfo().getDescription(), device.getDeviceInfo().getVendor(), device.getDeviceInfo().getVersion(), device.getMicrosecondPosition(), device.getMaxTransmitters(), device.getMaxReceivers()}));
    }

    public void logInstruments() {
        for (Instrument instrument : this.synthesizer.getAvailableInstruments()) {
            logger.info("Instrument {} ({}/{})", new Object[]{instrument.getName(), instrument.getPatch().getBank(), instrument.getPatch().getProgram()});
        }
    }
}

