/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.nashorn.core;

import java.util.stream.Stream;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.nashorn.core.NashornKnowledgeBaseInterpreter;

public class NashornKnowledgeBaseEngineOperations
extends BaseKnowledgeBaseEngineOperations {
    public NashornKnowledgeBaseEngineOperations(BaseEngine engine, KnowledgeBase knowledgeBase) {
        super(engine, knowledgeBase);
    }

    public void enable(Object processorClass) {
        this.engine.getProcessorManager().enable(this.getKnowledgeBase(), (Object)this.resolveProcessorName(processorClass));
    }

    public void enableAll(Object ... processorClasses) {
        Stream.of(processorClasses).forEach(processorClass -> this.enable(processorClass));
    }

    public void disable(Object processorClass) {
        this.engine.getProcessorManager().disable(this.getKnowledgeBase(), (Object)this.resolveProcessorName(processorClass));
    }

    public void disableAll(Object ... processorClasses) {
        Stream.of(processorClasses).forEach(processorClass -> this.disable(processorClass));
    }

    public void enableFilter(Object filterClass) {
        this.engine.getProcessorManager().enableFilter(this.getKnowledgeBase(), (Object)this.resolveProcessorName(filterClass));
    }

    public void enableFilters(Object ... filterClasses) {
        for (Object filterClass : filterClasses) {
            this.enableFilter(filterClass);
        }
    }

    public void disableFilter(Object filterClass) {
        this.engine.getProcessorManager().disableFilter(this.getKnowledgeBase(), (Object)this.resolveProcessorName(filterClass));
    }

    public void enableTrigger(Object triggerClass) {
        this.engine.getProcessorManager().enableTrigger(this.getKnowledgeBase(), (Object)this.resolveProcessorName(triggerClass));
    }

    public void enableTriggers(Object ... triggerClasses) {
        for (Object triggerClass : triggerClasses) {
            this.enableTrigger(triggerClass);
        }
    }

    public void disableTrigger(Object triggerClass) {
        this.engine.getProcessorManager().disableTrigger(this.getKnowledgeBase(), (Object)this.resolveProcessorName(triggerClass));
    }

    public void enableRule(Object ruleClass) {
        this.engine.getProcessorManager().enableRule(this.getKnowledgeBase(), (Object)this.resolveProcessorName(ruleClass));
    }

    public void enableRules(Object ... ruleClasses) {
        for (Object ruleClass : ruleClasses) {
            this.enableRule(ruleClass);
        }
    }

    public void disableRule(Object ruleClass) {
        this.engine.getProcessorManager().disableRule(this.getKnowledgeBase(), (Object)this.resolveProcessorName(ruleClass));
    }

    public void enableCorrelator(Object correlatorClass) {
        this.engine.getProcessorManager().enableCorrelator(this.getKnowledgeBase(), (Object)this.resolveProcessorName(correlatorClass));
    }

    public void enableCorrelators(Object ... correlatorClasses) {
        for (Object correlatorClass : correlatorClasses) {
            this.enableCorrelator(correlatorClass);
        }
    }

    public void disableCorrelator(Object correlatorClass) {
        this.engine.getProcessorManager().disableCorrelator(this.getKnowledgeBase(), (Object)this.resolveProcessorName(correlatorClass));
    }

    public void enableAction(Object actionClass) {
        this.engine.getProcessorManager().enableAction(this.getKnowledgeBase(), (Object)this.resolveProcessorName(actionClass));
    }

    public void enableActions(Object ... actionClasses) {
        for (Object actionClass : actionClasses) {
            this.enableAction(actionClass);
        }
    }

    public void disableAction(Object actionClass) {
        this.engine.getProcessorManager().disableAction(this.getKnowledgeBase(), (Object)this.resolveProcessorName(actionClass));
    }

    public NashornKnowledgeBaseInterpreter getInterpreter() {
        return (NashornKnowledgeBaseInterpreter)this.getKnowledgeBase().getInterpreter();
    }

    protected String resolveProcessorName(Object processorClass) {
        return processorClass instanceof String ? (String)processorClass : this.getInterpreter().resolveVariableName(processorClass);
    }
}

