/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.nashorn.core;

import java.util.ArrayList;
import java.util.Map;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.kb.EngineScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.correlator.Correlator;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.filter.Filter;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.nashorn.JavaScriptConstants;
import org.openksavi.sponge.nashorn.NashornAction;
import org.openksavi.sponge.nashorn.NashornCorrelator;
import org.openksavi.sponge.nashorn.NashornFilter;
import org.openksavi.sponge.nashorn.NashornPlugin;
import org.openksavi.sponge.nashorn.NashornRule;
import org.openksavi.sponge.nashorn.NashornTrigger;
import org.openksavi.sponge.nashorn.core.NashornKnowledgeBaseEngineOperations;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.trigger.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NashornKnowledgeBaseInterpreter
extends EngineScriptKnowledgeBaseInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(NashornKnowledgeBaseInterpreter.class);
    public static final String SCRIPT_ENGINE_NAME = "nashorn";
    public static final String INITIAL_SCRIPT = "sponge_nashorn_init.js";
    protected static final Map<Class, Class> PROCESSOR_CLASSES = SpongeUtils.immutableMapOf(Action.class, NashornAction.class, Filter.class, NashornFilter.class, Trigger.class, NashornTrigger.class, Rule.class, NashornRule.class, Correlator.class, NashornCorrelator.class);

    public NashornKnowledgeBaseInterpreter(SpongeEngine engine, KnowledgeBase knowledgeBase) {
        super((KnowledgeBaseEngineOperations)new NashornKnowledgeBaseEngineOperations((BaseSpongeEngine)engine, knowledgeBase), JavaScriptConstants.TYPE);
    }

    protected ScriptEngine createScriptEngine() {
        String scripEngineName = SCRIPT_ENGINE_NAME;
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        ScriptEngine result = factory.getScriptEngine(new String[]{"-scripting"});
        Validate.isInstanceOf(Compilable.class, (Object)result, (String)"ScriptingEngine %s doesn't implement Compilable", (Object[])new Object[]{scripEngineName});
        Validate.isInstanceOf(Invocable.class, (Object)result, (String)"ScriptingEngine %s doesn't implement Invocable", (Object[])new Object[]{scripEngineName});
        PROCESSOR_CLASSES.forEach((interfaceClass, scriptClass) -> this.addImport(result, (Class<?>)scriptClass, interfaceClass.getSimpleName()));
        this.addImport(result, NashornPlugin.class, Plugin.class.getSimpleName());
        this.getStandardImportClasses().forEach(cls -> this.addImport(result, (Class<?>)cls));
        result.put("EPS", this.getEngineOperations());
        this.eval(result, "load(\"classpath:sponge_nashorn_init.js\");");
        return result;
    }

    protected void addImport(ScriptEngine scriptEngine, Class<?> clazz) {
        this.addImport(scriptEngine, clazz, clazz.getSimpleName());
    }

    protected void addImport(ScriptEngine scriptEngine, Class<?> clazz, String alias) {
        this.eval(scriptEngine, "var " + alias + " = Packages." + clazz.getName() + ";");
    }

    public String getScriptKnowledgeBaseProcessorClassName(Object processorClass) {
        if (processorClass instanceof String) {
            return (String)processorClass;
        }
        return null;
    }

    protected ScriptKnowledgeBaseInterpreter createInterpreterInstance(SpongeEngine engine, KnowledgeBase knowledgeBase) {
        return new NashornKnowledgeBaseInterpreter(engine, knowledgeBase);
    }

    public void scanToAutoEnable() {
        ArrayList autoEnabled = new ArrayList();
        this.getScriptEngine().getBindings(100).forEach((key, value) -> {
            Object evalResult;
            Object object = evalResult = value != null ? this.eval(key + ".class") : null;
            if (evalResult != null && evalResult instanceof Class) {
                Class cls = (Class)evalResult;
                if (PROCESSOR_CLASSES.values().stream().filter(processorClass -> !cls.equals(processorClass) && ClassUtils.isAssignable((Class)cls, (Class)processorClass)).findFirst().isPresent() && !this.isProcessorAbstract((String)key)) {
                    autoEnabled.add(key);
                    ((NashornKnowledgeBaseEngineOperations)this.getEngineOperations()).enable(value);
                }
            }
        });
        if (logger.isDebugEnabled() && !autoEnabled.isEmpty()) {
            logger.debug("Auto-enabling: {}", autoEnabled);
        }
    }

    protected String getScriptClassInstancePoviderFormat() {
        return "new %s();";
    }
}

