/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.py4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.java.JavaPlugin;
import org.openksavi.sponge.py4j.SecurityConfiguration;

public abstract class BasePy4JPlugin<T>
extends JavaPlugin {
    public static final String DEFAULT_NAME = "py4j";
    public static final String TAG_FACADE_INTERFACE = "facadeInterface";
    public static final String TAG_JAVA_PORT = "javaPort";
    public static final String TAG_PYTHON_PORT = "pythonPort";
    public static final String TAG_SECURITY = "security";
    public static final String TAG_SECURITY_PASSWORD = "password";
    public static final String TAG_SECURITY_KEYSTORE = "keystore";
    public static final String TAG_SECURITY_ALGORITHM = "algorithm";
    public static final String DEFAULT_SECURITY_ALGORITHM = "SunX509";
    private String facadeInterfaceName;
    private T facade;
    private int javaPort = 25333;
    private int pythonPort = 25334;
    private SecurityConfiguration security;

    public BasePy4JPlugin() {
        this.setName(DEFAULT_NAME);
    }

    public T getFacade() {
        return this.facade;
    }

    public void setFacade(T facade) {
        this.facade = facade;
    }

    public String getFacadeInterfaceName() {
        return this.facadeInterfaceName;
    }

    public void setFacadeInterfaceName(String facadeInterfaceName) {
        this.facadeInterfaceName = facadeInterfaceName;
    }

    public void onConfigure(Configuration configuration) {
        this.facadeInterfaceName = configuration.getString(TAG_FACADE_INTERFACE, this.facadeInterfaceName);
        this.javaPort = configuration.getInteger(TAG_JAVA_PORT, Integer.valueOf(this.javaPort));
        this.pythonPort = configuration.getInteger(TAG_PYTHON_PORT, Integer.valueOf(this.pythonPort));
        if (configuration.hasChildConfiguration(TAG_SECURITY)) {
            Configuration securityConfiguration = configuration.getChildConfiguration(TAG_SECURITY);
            SecurityConfiguration newSecurity = new SecurityConfiguration();
            newSecurity.setPassword(Utils.getRequiredConfigurationString((Configuration)securityConfiguration, (String)TAG_SECURITY_PASSWORD));
            newSecurity.setKeystore(Utils.getRequiredConfigurationString((Configuration)securityConfiguration, (String)TAG_SECURITY_KEYSTORE));
            newSecurity.setAlgorithm(securityConfiguration.getString(TAG_SECURITY_ALGORITHM, DEFAULT_SECURITY_ALGORITHM));
            this.security = newSecurity;
        }
    }

    public Integer getJavaPort() {
        return this.javaPort;
    }

    public void setJavaPort(Integer javaPort) {
        this.javaPort = javaPort;
    }

    public Integer getPythonPort() {
        return this.pythonPort;
    }

    public void setPythonPort(Integer pythonPort) {
        this.pythonPort = pythonPort;
    }

    public SecurityConfiguration getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityConfiguration security) {
        this.security = security;
    }

    protected SSLContext createSslContext() {
        SSLContext sSLContext;
        InputStream fis = null;
        try {
            char[] password = this.security.getPassword().toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            URL keystoreUrl = Utils.getUrlFromClasspath((String)this.security.getKeystore());
            if (keystoreUrl == null) {
                throw new SpongeException("Expected a '" + this.security.getKeystore() + "' keystore file on the classpath");
            }
            fis = keystoreUrl.openStream();
            ks.load(fis, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.security.getAlgorithm());
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.security.getAlgorithm());
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            sSLContext = sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            try {
                throw Utils.wrapException((String)"createSslContext", (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.close(fis);
                throw throwable;
            }
        }
        Utils.close((InputStream)fis);
        return sSLContext;
    }
}

