/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.py4j;

import javax.net.ssl.SSLContext;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.core.util.SslConfiguration;
import org.openksavi.sponge.core.util.process.ProcessUtils;
import org.openksavi.sponge.java.JPlugin;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.openksavi.sponge.util.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SocketUtils;

public abstract class BasePy4JPlugin<T>
extends JPlugin {
    private static final Logger logger = LoggerFactory.getLogger(BasePy4JPlugin.class);
    public static final String DEFAULT_NAME = "py4j";
    public static final String TAG_FACADE_INTERFACE = "facadeInterface";
    public static final String TAG_JAVA_PORT = "javaPort";
    public static final String TAG_PYTHON_PORT = "pythonPort";
    public static final String TAG_SECURITY = "security";
    public static final String TAG_PYTHON_SCRIPT = "pythonScript";
    public static final String TAG_PYTHON_SCRIPT_BEFORE_STARTUP = "pythonScriptBeforeStartup";
    public static final String TAG_GENERATE_AUTH_TOKEN = "generateAuthToken";
    public static final String TAG_AUTH_TOKEN = "authToken";
    public static final String TAG_RANDOM_PORTS = "randomPorts";
    public static final String DEFAULT_PYTHON_EXECUTABLE = "python";
    public static final String ENV_PY4J_JAVA_PORT = "PY4J_JAVA_PORT";
    public static final String ENV_PY4J_PYTHON_PORT = "PY4J_PYTHON_PORT";
    public static final String ENV_PY4J_AUTH_TOKEN = "PY4J_AUTH_TOKEN";
    private String facadeInterfaceName;
    private T facade;
    private int javaPort = 25333;
    private int pythonPort = 25334;
    private SslConfiguration security;
    private ProcessConfiguration pythonScriptConfiguration;
    private boolean pythonScriptBeforeStartup = true;
    private boolean generateAuthToken = false;
    private String authToken;
    private boolean randomPorts = false;
    private ProcessInstance scriptProcess;

    public BasePy4JPlugin() {
        this.setName(DEFAULT_NAME);
    }

    public BasePy4JPlugin(String name) {
        super(name);
    }

    public void onStartup() {
        if (this.generateAuthToken) {
            this.authToken = SpongeUtils.getRandomUuidString();
        }
        if (this.randomPorts) {
            this.javaPort = SocketUtils.findAvailableTcpPort((int)25333);
            this.pythonPort = SocketUtils.findAvailableTcpPort((int)25334);
        }
        logger.info("Using port {} for Java, {} for Python. The auth token is {}.", new Object[]{this.javaPort, this.pythonPort, this.authToken});
    }

    protected void executePythonScript() {
        if (this.pythonScriptConfiguration != null) {
            ProcessConfiguration finalConfiguration = this.pythonScriptConfiguration.clone();
            finalConfiguration.getEnv().put(ENV_PY4J_JAVA_PORT, String.valueOf(this.javaPort));
            finalConfiguration.getEnv().put(ENV_PY4J_PYTHON_PORT, String.valueOf(this.pythonPort));
            if (this.authToken != null) {
                finalConfiguration.getEnv().put(ENV_PY4J_AUTH_TOKEN, this.authToken);
            }
            try {
                this.scriptProcess = this.getEngineOperations().process(finalConfiguration).run();
            }
            catch (InterruptedException e) {
                throw SpongeUtils.wrapException((Throwable)e);
            }
            if (this.scriptProcess.getOutputString() != null) {
                logger.info("Python script output: {}", (Object)this.scriptProcess.getOutputString());
            }
        }
    }

    public void killPythonScript() {
        try {
            if (this.scriptProcess != null) {
                this.scriptProcess.destroy();
            }
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    public ProcessInstance getScriptProcess() {
        return this.scriptProcess;
    }

    public void onConfigure(Configuration configuration) {
        this.facadeInterfaceName = configuration.getString(TAG_FACADE_INTERFACE, this.facadeInterfaceName);
        this.javaPort = configuration.getInteger(TAG_JAVA_PORT, Integer.valueOf(this.javaPort));
        this.pythonPort = configuration.getInteger(TAG_PYTHON_PORT, Integer.valueOf(this.pythonPort));
        if (configuration.hasChildConfiguration(TAG_SECURITY)) {
            this.security = SpongeUtils.createSslConfiguration((Configuration)configuration.getChildConfiguration(TAG_SECURITY));
        }
        if (configuration.hasChildConfiguration(TAG_PYTHON_SCRIPT)) {
            this.pythonScriptConfiguration = ProcessUtils.createProcessConfigurationBuilder((Configuration)configuration.getChildConfiguration(TAG_PYTHON_SCRIPT)).name("Python script").build();
            if (this.pythonScriptConfiguration.getExecutable() == null) {
                this.pythonScriptConfiguration.setExecutable(DEFAULT_PYTHON_EXECUTABLE);
            }
        }
        this.pythonScriptBeforeStartup = configuration.getBoolean(TAG_PYTHON_SCRIPT_BEFORE_STARTUP, Boolean.valueOf(this.pythonScriptBeforeStartup));
        this.generateAuthToken = configuration.getBoolean(TAG_GENERATE_AUTH_TOKEN, Boolean.valueOf(this.generateAuthToken));
        this.authToken = configuration.getString(TAG_AUTH_TOKEN, this.authToken);
        this.randomPorts = configuration.getBoolean(TAG_RANDOM_PORTS, Boolean.valueOf(this.randomPorts));
    }

    public T getFacade() {
        return this.facade;
    }

    public void setFacade(T facade) {
        this.facade = facade;
    }

    public String getFacadeInterfaceName() {
        return this.facadeInterfaceName;
    }

    public void setFacadeInterfaceName(String facadeInterfaceName) {
        this.facadeInterfaceName = facadeInterfaceName;
    }

    public ProcessConfiguration getPythonScriptConfiguration() {
        return this.pythonScriptConfiguration;
    }

    public void setPythonScriptConfiguration(ProcessConfiguration pythonScriptConfiguration) {
        this.pythonScriptConfiguration = pythonScriptConfiguration;
    }

    public boolean isPythonScriptBeforeStartup() {
        return this.pythonScriptBeforeStartup;
    }

    public void setPythonScriptBeforeStartup(boolean pythonScriptBeforeStartup) {
        this.pythonScriptBeforeStartup = pythonScriptBeforeStartup;
    }

    public int getJavaPort() {
        return this.javaPort;
    }

    public void setJavaPort(int javaPort) {
        this.javaPort = javaPort;
    }

    public int getPythonPort() {
        return this.pythonPort;
    }

    public void setPythonPort(int pythonPort) {
        this.pythonPort = pythonPort;
    }

    public SslConfiguration getSecurity() {
        return this.security;
    }

    public void setSecurity(SslConfiguration security) {
        this.security = security;
    }

    protected SSLContext createSslContext() {
        return SpongeUtils.createSslContext((SslConfiguration)this.security);
    }

    public boolean isGenerateAuthToken() {
        return this.generateAuthToken;
    }

    public void setGenerateAuthToken(boolean generateAuthToken) {
        this.generateAuthToken = generateAuthToken;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean isRandomPorts() {
        return this.randomPorts;
    }

    public void setRandomPorts(boolean randomPorts) {
        this.randomPorts = randomPorts;
    }
}

