/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.py4j;

import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ClassUtils;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.py4j.BasePy4JPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.ClientServer;

public class ClientServerPy4JPlugin<T>
extends BasePy4JPlugin<T> {
    private static final Logger logger = LoggerFactory.getLogger(ClientServerPy4JPlugin.class);
    public static final String TAG_AUTO_START_JAVA_SERVER = "autoStartJavaServer";
    protected ClientServer server;
    protected Boolean autoStartJavaServer;

    public ClientServerPy4JPlugin() {
    }

    public ClientServerPy4JPlugin(String name) {
        super(name);
    }

    @Override
    public void onConfigure(Configuration configuration) {
        super.onConfigure(configuration);
        this.autoStartJavaServer = configuration.getBoolean(TAG_AUTO_START_JAVA_SERVER, null);
    }

    public void onStartup() {
        if (this.server == null) {
            logger.info("Creating and starting the Py4J Server.");
            ClientServer.ClientServerBuilder builder = new ClientServer.ClientServerBuilder().javaPort(this.getJavaPort().intValue()).pythonPort(this.getPythonPort().intValue()).entryPoint((Object)this.getEngine().getOperations());
            if (this.getSecurity() != null) {
                SSLContext sslContext = this.createSslContext();
                builder.serverSocketFactory((ServerSocketFactory)sslContext.getServerSocketFactory()).socketFactory((SocketFactory)sslContext.getSocketFactory());
            }
            if (this.autoStartJavaServer != null) {
                builder.autoStartJavaServer(this.autoStartJavaServer.booleanValue());
            }
            this.server = this.build(builder);
        } else {
            logger.info("Using the manually created Py4J Server. Note that the server should have already been started.");
        }
        if (this.getFacadeInterfaceName() != null) {
            try {
                this.setFacade(this.server.getPythonServerEntryPoint(new Class[]{ClassUtils.getClass((String)this.getFacadeInterfaceName())}));
            }
            catch (Exception e) {
                throw SpongeUtils.wrapException((Throwable)e);
            }
        }
    }

    protected ClientServer build(ClientServer.ClientServerBuilder builder) {
        return builder.build();
    }

    public void onShutdown() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    public ClientServer getServer() {
        return this.server;
    }

    public void setServer(ClientServer server) {
        this.server = server;
    }

    public Boolean getAutoStartJavaServer() {
        return this.autoStartJavaServer;
    }

    public void setAutoStartJavaServer(Boolean autoStartJavaServer) {
        this.autoStartJavaServer = autoStartJavaServer;
    }
}

