/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.py4j;

import javax.net.ssl.SSLContext;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.core.util.SslConfiguration;
import org.openksavi.sponge.java.JPlugin;

public abstract class BasePy4JPlugin<T>
extends JPlugin {
    public static final String DEFAULT_NAME = "py4j";
    public static final String TAG_FACADE_INTERFACE = "facadeInterface";
    public static final String TAG_JAVA_PORT = "javaPort";
    public static final String TAG_PYTHON_PORT = "pythonPort";
    public static final String TAG_SECURITY = "security";
    private String facadeInterfaceName;
    private T facade;
    private int javaPort = 25333;
    private int pythonPort = 25334;
    private SslConfiguration security;

    public BasePy4JPlugin() {
        this.setName(DEFAULT_NAME);
    }

    public BasePy4JPlugin(String name) {
        super(name);
    }

    public T getFacade() {
        return this.facade;
    }

    public void setFacade(T facade) {
        this.facade = facade;
    }

    public String getFacadeInterfaceName() {
        return this.facadeInterfaceName;
    }

    public void setFacadeInterfaceName(String facadeInterfaceName) {
        this.facadeInterfaceName = facadeInterfaceName;
    }

    public void onConfigure(Configuration configuration) {
        this.facadeInterfaceName = configuration.getString(TAG_FACADE_INTERFACE, this.facadeInterfaceName);
        this.javaPort = configuration.getInteger(TAG_JAVA_PORT, Integer.valueOf(this.javaPort));
        this.pythonPort = configuration.getInteger(TAG_PYTHON_PORT, Integer.valueOf(this.pythonPort));
        if (configuration.hasChildConfiguration(TAG_SECURITY)) {
            this.security = SpongeUtils.createSecurityConfiguration((Configuration)configuration.getChildConfiguration(TAG_SECURITY));
        }
    }

    public Integer getJavaPort() {
        return this.javaPort;
    }

    public void setJavaPort(Integer javaPort) {
        this.javaPort = javaPort;
    }

    public Integer getPythonPort() {
        return this.pythonPort;
    }

    public void setPythonPort(Integer pythonPort) {
        this.pythonPort = pythonPort;
    }

    public SslConfiguration getSecurity() {
        return this.security;
    }

    public void setSecurity(SslConfiguration security) {
        this.security = security;
    }

    protected SSLContext createSslContext() {
        return SpongeUtils.createSslContext((SslConfiguration)this.security);
    }
}

