/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.py4j;

import javax.net.ssl.SSLContext;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.ProcessConfiguration;
import org.openksavi.sponge.core.util.ProcessInstance;
import org.openksavi.sponge.core.util.ProcessUtils;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.core.util.SslConfiguration;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.java.JPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePy4JPlugin<T>
extends JPlugin {
    private static final Logger logger = LoggerFactory.getLogger(BasePy4JPlugin.class);
    public static final String DEFAULT_NAME = "py4j";
    public static final String TAG_FACADE_INTERFACE = "facadeInterface";
    public static final String TAG_JAVA_PORT = "javaPort";
    public static final String TAG_PYTHON_PORT = "pythonPort";
    public static final String TAG_SECURITY = "security";
    public static final String TAG_PYTHON_SCRIPT = "pythonScript";
    public static final String TAG_PYTHON_SCRIPT_BEFORE_STARTUP = "pythonScriptBeforeStartup";
    public static final String DEFAULT_PYTHON_EXECUTABLE = "python";
    private String facadeInterfaceName;
    private T facade;
    private int javaPort = 25333;
    private int pythonPort = 25334;
    private SslConfiguration security;
    private ProcessConfiguration pythonScriptConfiguration;
    private boolean pythonScriptBeforeStartup = true;
    private ProcessInstance scriptProcess;

    public BasePy4JPlugin() {
        this.setName(DEFAULT_NAME);
    }

    public BasePy4JPlugin(String name) {
        super(name);
    }

    protected void executePythonScript() {
        if (this.pythonScriptConfiguration != null) {
            this.scriptProcess = SpongeUtils.startProcess((SpongeEngine)this.getEngine(), (ProcessConfiguration)this.pythonScriptConfiguration);
            if (this.scriptProcess.getOutput() != null) {
                logger.info("Python script output: {}", (Object)this.scriptProcess.getOutput());
            }
        }
    }

    public void killPythonScript() {
        if (this.scriptProcess != null) {
            this.scriptProcess.getProcess().destroy();
        }
    }

    public ProcessInstance getScriptProcess() {
        return this.scriptProcess;
    }

    public void onConfigure(Configuration configuration) {
        this.facadeInterfaceName = configuration.getString(TAG_FACADE_INTERFACE, this.facadeInterfaceName);
        this.javaPort = configuration.getInteger(TAG_JAVA_PORT, Integer.valueOf(this.javaPort));
        this.pythonPort = configuration.getInteger(TAG_PYTHON_PORT, Integer.valueOf(this.pythonPort));
        if (configuration.hasChildConfiguration(TAG_SECURITY)) {
            this.security = SpongeUtils.createSslConfiguration((Configuration)configuration.getChildConfiguration(TAG_SECURITY));
        }
        if (configuration.hasChildConfiguration(TAG_PYTHON_SCRIPT)) {
            this.pythonScriptConfiguration = ProcessUtils.createProcessConfigurationBuilder((Configuration)configuration.getChildConfiguration(TAG_PYTHON_SCRIPT)).name("Python script").build();
            if (this.pythonScriptConfiguration.getExecutable() == null) {
                this.pythonScriptConfiguration.setExecutable(DEFAULT_PYTHON_EXECUTABLE);
            }
        }
        this.pythonScriptBeforeStartup = configuration.getBoolean(TAG_PYTHON_SCRIPT_BEFORE_STARTUP, Boolean.valueOf(this.pythonScriptBeforeStartup));
    }

    public T getFacade() {
        return this.facade;
    }

    public void setFacade(T facade) {
        this.facade = facade;
    }

    public String getFacadeInterfaceName() {
        return this.facadeInterfaceName;
    }

    public void setFacadeInterfaceName(String facadeInterfaceName) {
        this.facadeInterfaceName = facadeInterfaceName;
    }

    public ProcessConfiguration getPythonScriptConfiguration() {
        return this.pythonScriptConfiguration;
    }

    public void setPythonScriptConfiguration(ProcessConfiguration pythonScriptConfiguration) {
        this.pythonScriptConfiguration = pythonScriptConfiguration;
    }

    public boolean isPythonScriptBeforeStartup() {
        return this.pythonScriptBeforeStartup;
    }

    public void setPythonScriptBeforeStartup(boolean pythonScriptBeforeStartup) {
        this.pythonScriptBeforeStartup = pythonScriptBeforeStartup;
    }

    public Integer getJavaPort() {
        return this.javaPort;
    }

    public void setJavaPort(Integer javaPort) {
        this.javaPort = javaPort;
    }

    public Integer getPythonPort() {
        return this.pythonPort;
    }

    public void setPythonPort(Integer pythonPort) {
        this.pythonPort = pythonPort;
    }

    public SslConfiguration getSecurity() {
        return this.security;
    }

    public void setSecurity(SslConfiguration security) {
        this.security = security;
    }

    protected SSLContext createSslContext() {
        return SpongeUtils.createSslContext((SslConfiguration)this.security);
    }
}

