/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.py4j;

import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ClassUtils;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.py4j.BasePy4JPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class GatewayServerPy4JPlugin<T>
extends BasePy4JPlugin<T> {
    private static final Logger logger = LoggerFactory.getLogger(GatewayServerPy4JPlugin.class);
    protected GatewayServer server;

    public GatewayServerPy4JPlugin() {
    }

    public GatewayServerPy4JPlugin(String name) {
        super(name);
    }

    public void onStartup() {
        if (this.isPythonScriptBeforeStartup()) {
            this.executePythonScript();
        }
        if (this.server == null) {
            logger.info("Creating and starting the Py4J Server.");
            GatewayServer.GatewayServerBuilder builder = new GatewayServer.GatewayServerBuilder().javaPort(this.getJavaPort().intValue()).entryPoint((Object)this.getEngine().getOperations());
            if (this.getSecurity() != null) {
                SSLContext sslContext = this.createSslContext();
                builder.serverSocketFactory((ServerSocketFactory)sslContext.getServerSocketFactory());
            }
            this.server = this.build(builder);
            this.server.start();
        } else {
            logger.info("Using the manually created Py4J Server. Note that the server should have already been started.");
        }
        if (this.getFacadeInterfaceName() != null) {
            try {
                this.setFacade(this.server.getPythonServerEntryPoint(new Class[]{ClassUtils.getClass((String)this.getFacadeInterfaceName())}));
            }
            catch (Exception e) {
                throw SpongeUtils.wrapException((Throwable)e);
            }
        }
        if (!this.isPythonScriptBeforeStartup()) {
            this.executePythonScript();
        }
    }

    protected GatewayServer build(GatewayServer.GatewayServerBuilder builder) {
        return builder.build();
    }

    public void onShutdown() {
        if (!this.isPythonScriptBeforeStartup()) {
            this.killPythonScript();
        }
        if (this.server != null) {
            this.server.shutdown();
        }
        if (this.isPythonScriptBeforeStartup()) {
            this.killPythonScript();
        }
    }

    public GatewayServer getServer() {
        return this.server;
    }

    public void setServer(GatewayServer server) {
        this.server = server;
    }
}

