/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.reactivex;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JPlugin;
import org.openksavi.sponge.reactivex.ReactiveXCorrelator;

public class ReactiveXPlugin
extends JPlugin {
    public static final String DEFAULT_PLUGIN_NAME = "rx";
    private PublishSubject<Event> subject;
    private Observable<Event> observable;

    public ReactiveXPlugin() {
        this.setName(DEFAULT_PLUGIN_NAME);
    }

    public ReactiveXPlugin(String name) {
        super(name);
    }

    public void onConfigure(Configuration configuration) {
        this.subject = PublishSubject.create();
        this.observable = this.subject.filter(event -> !SpongeUtils.isSystemEvent((Event)event));
    }

    public void onStartup() {
        this.getEngineOperations().enableJavaCorrelator(ReactiveXCorrelator.class);
    }

    public Observable<Event> getObservable() {
        return this.observable;
    }

    public PublishSubject<Event> getSubject() {
        return this.subject;
    }
}

