/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.signal;

import org.openksavi.sponge.signal.SystemSignalListener;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SystemSignal
implements SignalHandler {
    public static final String SIGHUP = "HUP";
    public static final String SIGINT = "INT";
    public static final String SIGQUIT = "QUIT";
    public static final String SIGILL = "ILL";
    public static final String SIGABRT = "ABRT";
    public static final String SIGKILL = "KILL";
    public static final String SIGALRM = "ALRM";
    public static final String SIGTERM = "TERM";
    public static final String SIGSTOP = "STOP";
    private Signal signal;
    private SystemSignalListener listener;

    protected SystemSignal(String signalName, SystemSignalListener listener) {
        this.listener = listener;
        this.signal = new Signal(signalName);
        Signal.handle(this.signal, this);
    }

    public String getName() {
        return this.signal.getName();
    }

    @Override
    public void handle(Signal signal) {
        if (this.listener != null) {
            this.listener.signalReceived(this);
        }
    }

    public String toString() {
        return this.signal.toString();
    }

    public boolean isSignal(String signalName) {
        return this.signal.getName().equals(signalName);
    }

    public static SystemSignal setSystemSignalListener(String signalName, SystemSignalListener listener) {
        return new SystemSignal(signalName, listener);
    }
}

