/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.springboot;

import java.util.List;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.engine.ConfigurationManager;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.spring.SpringEngineBuilder;
import org.openksavi.sponge.spring.SpringPlugin;
import org.openksavi.sponge.spring.SpringSpongeEngine;
import org.openksavi.sponge.springboot.BootKnowledgeBase;
import org.openksavi.sponge.springboot.SpongeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SpongeEngine.class})
@EnableConfigurationProperties(value={SpongeProperties.class})
public class SpongeAutoConfiguration {
    private static final String DEFAULT_CONFIG_FILE = "config/sponge.xml";
    @Autowired
    private SpongeProperties spongeProperties;

    @Bean
    @ConditionalOnMissingBean(value={SpongeEngine.class})
    public SpongeEngine spongeEngine(List<Plugin> plugins, List<KnowledgeBase> knowledgeBases) {
        String spongeHome;
        SpringEngineBuilder builder = SpringSpongeEngine.builder();
        plugins.forEach(arg_0 -> ((SpringEngineBuilder)builder).plugin(arg_0));
        BootKnowledgeBase bootKnowledgeBase = new BootKnowledgeBase();
        builder.knowledgeBase((KnowledgeBase)bootKnowledgeBase);
        knowledgeBases.forEach(arg_0 -> ((SpringEngineBuilder)builder).knowledgeBase(arg_0));
        String processorBeansKnowledgeBaseName = this.spongeProperties.getProcessorBeansKnowledgeBaseName();
        builder.processorBeansKnowledgeBaseName(processorBeansKnowledgeBaseName != null ? processorBeansKnowledgeBaseName : bootKnowledgeBase.getName());
        String string = spongeHome = this.spongeProperties.getHome() != null ? this.spongeProperties.getHome() : System.getProperty("sponge.home");
        if (spongeHome == null) {
            spongeHome = ".";
        }
        builder.property("sponge.home", (Object)spongeHome);
        String configFile = this.spongeProperties.getConfigFile();
        if (configFile != null) {
            builder.config(this.spongeProperties.getConfigFile());
            if (this.spongeProperties.getIgnoreConfigurationFileNotFound() != null) {
                builder.ignoreConfigurationFileNotFound(this.spongeProperties.getIgnoreConfigurationFileNotFound());
            }
        } else {
            builder.config(DEFAULT_CONFIG_FILE);
            builder.ignoreConfigurationFileNotFound(Boolean.valueOf(this.spongeProperties.getIgnoreConfigurationFileNotFound() != null ? this.spongeProperties.getIgnoreConfigurationFileNotFound() : true));
        }
        this.setupSpongeEngineBuilder(builder);
        BaseSpongeEngine engine = builder.build();
        this.setupSpongeProperties((SpongeEngine)engine);
        this.setupSpongeEngine((SpongeEngine)engine, this.spongeProperties.getEngine());
        return engine;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringPlugin.class})
    public SpringPlugin springPlugin() {
        return new SpringPlugin();
    }

    protected void setupSpongeEngineBuilder(SpringEngineBuilder builder) {
        if (this.spongeProperties.getName() != null) {
            builder.name(this.spongeProperties.getName());
        }
        if (this.spongeProperties.getLabel() != null) {
            builder.label(this.spongeProperties.getLabel());
        }
        if (this.spongeProperties.getDescription() != null) {
            builder.description(this.spongeProperties.getDescription());
        }
        if (this.spongeProperties.getLicense() != null) {
            builder.license(this.spongeProperties.getLicense());
        }
        if (this.spongeProperties.getDefaultKnowledgeBaseName() != null) {
            builder.defaultKnowledgeBaseName(this.spongeProperties.getDefaultKnowledgeBaseName());
        }
        if (this.spongeProperties.getAutoStartup() != null) {
            builder.autoStartup(this.spongeProperties.getAutoStartup().booleanValue());
        }
        if (this.spongeProperties.getPhase() != null) {
            builder.phase(this.spongeProperties.getPhase().intValue());
        }
        if (this.spongeProperties.getProcessorBeansKnowledgeBaseName() != null) {
            builder.processorBeansKnowledgeBaseName(this.spongeProperties.getProcessorBeansKnowledgeBaseName());
        }
    }

    protected void setupSpongeProperties(SpongeEngine engine) {
        ConfigurationManager configuration = engine.getConfigurationManager();
        this.spongeProperties.getProperties().forEach((name, value) -> configuration.setProperty(name, value));
        this.spongeProperties.getSystemProperties().forEach((name, value) -> configuration.setSystemProperty(name, value));
        this.spongeProperties.getVariableProperties().forEach((name, value) -> configuration.setVariableProperty(name, value));
    }

    protected void setupSpongeEngine(SpongeEngine engine, SpongeProperties.EngineProperties engineProperties) {
        ConfigurationManager configuration = engine.getConfigurationManager();
        if (engineProperties.getMainProcessingUnitThreadCount() != null) {
            configuration.setMainProcessingUnitThreadCount(engineProperties.getMainProcessingUnitThreadCount().intValue());
        }
        if (engineProperties.getEventClonePolicy() != null) {
            configuration.setEventClonePolicy(engineProperties.getEventClonePolicy());
        }
        if (engineProperties.getEventQueueCapacity() != null) {
            configuration.setEventQueueCapacity(engineProperties.getEventQueueCapacity().intValue());
        }
        if (engineProperties.getDurationThreadCount() != null) {
            configuration.setDurationThreadCount(engineProperties.getDurationThreadCount().intValue());
        }
        if (engineProperties.getAsyncEventSetProcessorExecutorThreadCount() != null) {
            configuration.setAsyncEventSetProcessorExecutorThreadCount(engineProperties.getAsyncEventSetProcessorExecutorThreadCount().intValue());
        }
        if (engineProperties.getEventSetProcessorDefaultSynchronous() != null) {
            configuration.setEventSetProcessorDefaultSynchronous(engineProperties.getEventSetProcessorDefaultSynchronous().booleanValue());
        }
        if (engineProperties.getAutoEnable() != null) {
            configuration.setAutoEnable(engineProperties.getAutoEnable().booleanValue());
        }
        if (engineProperties.getExecutorShutdownTimeout() != null) {
            configuration.setExecutorShutdownTimeout(engineProperties.getExecutorShutdownTimeout().longValue());
        }
    }
}

