/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.spring;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openksavi.sponge.config.ConfigException;
import org.openksavi.sponge.kb.KnowledgeBaseReaderHolder;
import org.openksavi.sponge.spring.SpringKnowledgeBaseFileProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class SpringUtils {
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver(SpringKnowledgeBaseFileProvider.class.getClassLoader());

    public static List<KnowledgeBaseReaderHolder> getReadersFromResourcePatternResolver(String filename, Charset charset) throws IOException {
        Resource[] resources = null;
        try {
            resources = RESOURCE_RESOLVER.getResources(filename);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        return Arrays.stream(resources).filter(Resource::exists).map(resource -> {
            try {
                return new KnowledgeBaseReaderHolder((Reader)new InputStreamReader(resource.getInputStream()), resource.getURL() != null ? resource.getURL().toString() : resource.toString());
            }
            catch (IOException e) {
                throw new ConfigException("Error reading " + resource, (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    protected SpringUtils() {
    }
}

