/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.spring;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.openksavi.sponge.spring.SpringKnowledgeBaseFileProvider;
import org.openksavi.sponge.spring.SpringUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.Nullable;

public class SpringResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    private static final ResourcePatternResolver BASE_RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver(SpringKnowledgeBaseFileProvider.class.getClassLoader());

    public SpringResourcePatternResolver(@Nullable ClassLoader classLoader) {
        super(classLoader);
        ((DefaultResourceLoader)this.getResourceLoader()).addProtocolResolver((location, resourceLoader) -> {
            if (!location.startsWith("spar:")) {
                return null;
            }
            String path = location.substring("spar:".length());
            if (location.contains(".jar!/")) {
                return BASE_RESOURCE_RESOLVER.getResource("file:" + path);
            }
            if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
                return BASE_RESOURCE_RESOLVER.getResource("file:" + path);
            }
            return null;
        });
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        if (SpringUtils.isSparArchive(resource)) {
            return true;
        }
        return super.isJarResource(resource);
    }
}

