/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.spring;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBaseReaderHolder;
import org.openksavi.sponge.spring.SpringKnowledgeBaseReaderResolver;
import org.springframework.core.io.Resource;

public abstract class SpringUtils {
    public static List<KnowledgeBaseReaderHolder> getReadersFromResourcePatternResolver(String filename, Charset charset) throws IOException {
        return new SpringKnowledgeBaseReaderResolver(filename, charset).resolve();
    }

    public static boolean isSparArchive(Resource resource) {
        try {
            return Objects.equals(resource.getURL().getProtocol(), "file") && (resource.getURL().getFile().endsWith(".jar") || resource.getURL().getFile().contains(".jar!/"));
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
    }

    protected SpringUtils() {
    }
}

