/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.spring;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.config.ConfigException;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBaseReaderHolder;
import org.openksavi.sponge.spring.SpringResourcePatternResolver;
import org.openksavi.sponge.spring.SpringUtils;
import org.springframework.core.io.Resource;

public class SpringKnowledgeBaseReaderResolver {
    private static final SpringResourcePatternResolver RESOURCE_RESOLVER = new SpringResourcePatternResolver(SpringUtils.class.getClassLoader());
    private String filename;
    private Charset charset;

    public SpringKnowledgeBaseReaderResolver(String filename, Charset charset) {
        this.filename = filename;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KnowledgeBaseReaderHolder> resolve() throws IOException {
        ArrayList resources = new ArrayList();
        this.creatEffectiveFilenames().forEach(effectiveFilename -> {
            block2: {
                try {
                    resources.addAll(Arrays.asList(RESOURCE_RESOLVER.getResources((String)effectiveFilename)));
                }
                catch (IOException e) {
                    if (e instanceof FileNotFoundException) break block2;
                    throw SpongeUtils.wrapException((Throwable)e);
                }
            }
        });
        LinkedHashMap sparJarFileCache = new LinkedHashMap();
        try {
            List<KnowledgeBaseReaderHolder> list = resources.stream().map(resource -> {
                try {
                    InputStream is = null;
                    is = resource.exists() ? resource.getInputStream() : this.tryCreateSparEntryInputStream((Resource)resource, sparJarFileCache);
                    return is != null ? new KnowledgeBaseReaderHolder((Reader)new InputStreamReader(is, this.charset), resource.getURL() != null ? resource.getURL().toString() : resource.toString()) : null;
                }
                catch (IOException e) {
                    throw new ConfigException("Error reading " + resource, (Throwable)e);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
        finally {
            sparJarFileCache.values().forEach(jarFile -> {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw SpongeUtils.wrapException((Throwable)e);
                }
            });
        }
    }

    protected List<String> creatEffectiveFilenames() throws IOException {
        int sparArchiveSeparatorIndex;
        ArrayList<String> effectiveFilenames = new ArrayList<String>();
        if (this.filename != null && this.filename.startsWith("spar:") && (sparArchiveSeparatorIndex = this.filename.lastIndexOf("!/")) > -1) {
            String archiveSpec = this.filename.substring(0, sparArchiveSeparatorIndex);
            String archiveContentsSpec = this.filename.substring(sparArchiveSeparatorIndex);
            if (archiveSpec.contains("*")) {
                Arrays.asList(RESOURCE_RESOLVER.getResources(archiveSpec)).forEach(resource -> {
                    try {
                        effectiveFilenames.add("spar:" + resource.getFile().getAbsolutePath() + archiveContentsSpec);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException e) {
                        throw SpongeUtils.wrapException((Throwable)e);
                    }
                });
            }
        }
        if (effectiveFilenames.isEmpty()) {
            effectiveFilenames.add(this.filename);
        }
        return effectiveFilenames;
    }

    protected InputStream tryCreateSparEntryInputStream(Resource resource, Map<String, JarFile> sparJarFileCache) throws IOException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        String spec = file.getCanonicalPath();
        int sparSeparatorIndex = spec.lastIndexOf("!/");
        if (sparSeparatorIndex < 0) {
            return null;
        }
        String archive = spec.substring(0, sparSeparatorIndex);
        if (!sparJarFileCache.containsKey(archive)) {
            File archiveFile = new File(archive);
            if (!archiveFile.isFile()) {
                return null;
            }
            sparJarFileCache.put(archive, new JarFile(archiveFile));
        }
        JarFile jar = sparJarFileCache.get(archive);
        String kbFile = spec.substring(archive.length() + "!/".length());
        ZipEntry entry = (ZipEntry)Validate.notNull((Object)jar.getEntry(kbFile), (String)"The JAR entry %s not found", (Object[])new Object[]{kbFile});
        return new ByteArrayInputStream(IOUtils.readFully((InputStream)jar.getInputStream(entry), (int)((int)entry.getSize())));
    }
}

