/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.spring;

import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.spring.SpringEngineBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;

public class SpringSpongeEngine
extends BaseSpongeEngine
implements ApplicationContextAware,
SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(SpringSpongeEngine.class);
    private ApplicationContext applicationContext;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private String processorBeansKnowledgeBaseName;

    public static SpringEngineBuilder builder() {
        return new SpringEngineBuilder(new SpringSpongeEngine());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void start() {
        if (this.autoStartup) {
            this.startup();
        }
    }

    public void stop() {
        if (this.autoStartup) {
            this.shutdown();
        }
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public String getProcessorBeansKnowledgeBaseName() {
        return this.processorBeansKnowledgeBaseName;
    }

    public void setProcessorBeansKnowledgeBaseName(String processorBeansKnowledgeBaseName) {
        this.processorBeansKnowledgeBaseName = processorBeansKnowledgeBaseName;
    }

    public void tryEnableProcessorBeans() {
        if (this.applicationContext != null) {
            this.enableProcessorBeans();
        } else {
            logger.warn("A Spring application context is not set. Processor beans will not be scanned.");
        }
    }

    public void enableProcessorBeans() {
        Validate.notNull((Object)this.applicationContext, (String)"A Spring application context is not set", (Object[])new Object[0]);
        Map processors = this.applicationContext.getBeansOfType(Processor.class);
        KnowledgeBase knowledgeBase = this.processorBeansKnowledgeBaseName != null ? this.getKnowledgeBaseManager().getKnowledgeBase(this.processorBeansKnowledgeBaseName) : this.getKnowledgeBaseManager().getDefaultKnowledgeBase();
        processors.values().forEach(processor -> this.getProcessorManager().enable(knowledgeBase, processor));
    }
}

