/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.kb.DefaultKnowledgeBaseFileProvider;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.kb.KnowledgeBaseReaderHolder;
import org.openksavi.sponge.spring.SpringUtils;
import org.springframework.util.ResourceUtils;

public class SpringKnowledgeBaseFileProvider
implements KnowledgeBaseFileProvider {
    private KnowledgeBaseFileProvider defaultKnowledgeBaseFileProvider = new DefaultKnowledgeBaseFileProvider();

    public List<KnowledgeBaseReaderHolder> getReaders(SpongeEngine engine, String fileName, Charset charset) {
        try {
            File file = null;
            try {
                file = ResourceUtils.getFile((String)fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (file != null && file.exists()) {
                return Arrays.asList(new KnowledgeBaseReaderHolder((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), fileName));
            }
            List<KnowledgeBaseReaderHolder> springResolverReaders = SpringUtils.getReadersFromResourcePatternResolver(fileName, charset);
            if (!springResolverReaders.isEmpty()) {
                return springResolverReaders;
            }
            return this.defaultKnowledgeBaseFileProvider.getReaders(engine, fileName, charset);
        }
        catch (IOException e) {
            throw new SpongeException("Error reading " + fileName, (Throwable)e);
        }
    }
}

