/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoPlugin
extends JavaPlugin {
    private static final Logger logger = LoggerFactory.getLogger(EchoPlugin.class);
    private String echo = "noecho";
    private int count = 1;

    public void onConfigure(Configuration configuration) {
        this.echo = configuration.getString("echo", this.echo);
        this.count = configuration.getInteger("count", Integer.valueOf(this.count));
    }

    public void onInit() {
        logger.debug("Initializing {}", (Object)this.getName());
    }

    public void onStartup() {
        logger.debug("Starting up {}", (Object)this.getName());
    }

    public String getEcho() {
        return this.echo;
    }

    public void setEcho(String echo) {
        this.echo = echo;
    }

    public int getCount() {
        return this.count;
    }

    public String getEchoConfig() {
        return this.echo + " x " + this.count;
    }

    public void sendEchoEvent() {
        this.getEps().event("echoEvent").set("echo", (Object)this.getEcho()).send();
    }
}

