/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.TestUtils;
import org.openksavi.sponge.test.script.util.ScriptTestUtils;

public class FiltersTestTemplate {
    public static void testJavaFilter(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters_java");
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "e2") >= 5 && TestUtils.getEventCounter(engine, "e3") >= 5);
            Assert.assertEquals((long)0L, (long)TestUtils.getEventCounter(engine, "e1"));
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testFilter(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters");
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "blue") >= 1);
            Assert.assertEquals((long)0L, (long)TestUtils.getEventCounter(engine, "red"));
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testDeduplication(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters_deduplication");
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "e2-red") >= 2 && TestUtils.getEventCounter(engine, "e2-blue") >= 2);
            Assert.assertEquals((long)1L, (long)TestUtils.getEventCounter(engine, "e1-red"));
            Assert.assertEquals((long)1L, (long)TestUtils.getEventCounter(engine, "e1-blue"));
            Assert.assertEquals((long)2L, (long)TestUtils.getEventCounter(engine, "e2-red"));
            Assert.assertEquals((long)2L, (long)TestUtils.getEventCounter(engine, "e2-blue"));
        }
        finally {
            engine.shutdown();
        }
    }
}

