/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.script.util.ScriptTestUtils;

public class PluginsTestTemplate {
    public static void testJavaPlugin(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "plugins_java");
        try {
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("connectionName") != null);
            Assert.assertEquals((Object)"Example connection", (Object)engine.getOperations().getVariable("connectionName"));
            Assert.assertEquals((Object)"Echo test! x 2", (Object)engine.getOperations().getVariable("echoConfig"));
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testScriptPlugin(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "plugins_script");
        try {
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("valueAfter") != null);
            Assert.assertEquals((Object)"Value A", (Object)engine.getOperations().getVariable("valueBefore"));
            Assert.assertEquals((Object)"Value B", (Object)engine.getOperations().getVariable("valueAfter"));
        }
        finally {
            engine.shutdown();
        }
    }
}

