/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.script.util.ScriptTestUtils;

public class TriggersTestTemplate {
    public static void testTriggers(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "triggers");
        try {
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(2L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("receivedEventA")).get());
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("receivedEventBCount")).intValue() > 2);
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("receivedEventTestJavaCount")).intValue() == 1);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testHelloWorld(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "hello_world");
        try {
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertNull((Object)engine.getError());
        }
        catch (InterruptedException e) {
            throw new SpongeException((Throwable)e);
        }
        finally {
            engine.shutdown();
        }
    }
}

