/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.TestUtils;
import org.openksavi.sponge.test.script.util.ScriptTestUtils;

public class EventsTestTemplate {
    private static String getValue(List<Event> events, int index) {
        return (String)((Map)events.get(index).get("map")).get("a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testClonePolicy(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "events_clone_policy");
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> TestUtils.getEvents(engine, "defaultClonePolicy").size() >= 3 && TestUtils.getEvents(engine, "deepClonePolicy").size() >= 3 && TestUtils.getEvents(engine, "shallowClonePolicy").size() >= 3);
            List<Event> defaultClonePolicyEvents = TestUtils.getEvents(engine, "defaultClonePolicy");
            Assert.assertEquals((Object)"Value 1", (Object)EventsTestTemplate.getValue(defaultClonePolicyEvents, 0));
            Assert.assertEquals((Object)"Value 2", (Object)EventsTestTemplate.getValue(defaultClonePolicyEvents, 1));
            Assert.assertEquals((Object)"Value 3", (Object)EventsTestTemplate.getValue(defaultClonePolicyEvents, 2));
            List<Event> deepClonePolicyEvents = TestUtils.getEvents(engine, "deepClonePolicy");
            Assert.assertEquals((Object)"Value 1", (Object)EventsTestTemplate.getValue(deepClonePolicyEvents, 0));
            Assert.assertEquals((Object)"Value 2", (Object)EventsTestTemplate.getValue(deepClonePolicyEvents, 1));
            Assert.assertEquals((Object)"Value 3", (Object)EventsTestTemplate.getValue(deepClonePolicyEvents, 2));
            List<Event> shallowClonePolicyEvents = TestUtils.getEvents(engine, "shallowClonePolicy");
            Assert.assertEquals((Object)("Value " + defaultClonePolicyEvents.size()), (Object)EventsTestTemplate.getValue(shallowClonePolicyEvents, 0));
            Assert.assertEquals((Object)("Value " + defaultClonePolicyEvents.size()), (Object)EventsTestTemplate.getValue(shallowClonePolicyEvents, 1));
            Assert.assertEquals((Object)("Value " + defaultClonePolicyEvents.size()), (Object)EventsTestTemplate.getValue(shallowClonePolicyEvents, 2));
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testCron(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "events_cron");
        try {
            Awaitility.await().atMost(15L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("eventCounter")).intValue() >= 2);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRemovingEvent(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "events_removing");
        try {
            Awaitility.await().pollDelay(3L, TimeUnit.SECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("eventCounter")).intValue() == ((Number)engine.getOperations().getVariable("allowNumber")).intValue());
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertEquals((long)((Number)engine.getOperations().getVariable("allowNumber")).intValue(), (long)((Number)engine.getOperations().getVariable("eventCounter")).intValue());
        }
        catch (InterruptedException ie) {
            throw new SpongeException((Throwable)ie);
        }
        finally {
            engine.shutdown();
        }
    }
}

