/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.util;

import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.engine.DefaultEngine;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseType;

public class ScriptTestUtils {
    public static String getScriptConfigFileName(KnowledgeBaseType type, String config) {
        return "examples/script/" + type.getFileExtension() + "/" + config + ".xml";
    }

    public static String getScriptKnowledgeBaseDir(KnowledgeBaseType type) {
        return "examples/script/" + type.getFileExtension();
    }

    public static String getScriptKnowledgeBaseFileName(KnowledgeBaseType type, String knowledgeBaseFile) {
        return ScriptTestUtils.getScriptKnowledgeBaseDir(type) + "/" + knowledgeBaseFile + "." + type.getFileExtension();
    }

    public static Engine startWithKnowledgeBase(KnowledgeBaseType type, String knowledgeBaseFile) {
        BaseEngine engine = DefaultEngine.builder().knowledgeBase("kb", type, new String[]{ScriptTestUtils.getScriptKnowledgeBaseFileName(type, knowledgeBaseFile)}).build();
        engine.startup();
        return engine;
    }

    public static Engine startWithConfig(KnowledgeBaseType type, String config) {
        BaseEngine engine = DefaultEngine.builder().config(ScriptTestUtils.getScriptConfigFileName(type, config)).build();
        engine.startup();
        return engine;
    }
}

