/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JavaCorrelator;

public class SampleJavaCorrelator
extends JavaCorrelator {
    private List<Event> eventLog;

    public void onConfigure() {
        this.setEvents(new String[]{"filesystemFailure", "diskFailure"});
        this.setMaxInstances(1);
    }

    public boolean onAcceptAsFirst(Event event) {
        return event.getName().equals("filesystemFailure");
    }

    public void onInit() {
        this.eventLog = new ArrayList<Event>();
    }

    public void onEvent(Event event) {
        this.eventLog.add(event);
        this.getLogger().debug("{} - event: {}, log: {}", new Object[]{((Object)((Object)this)).hashCode(), event.getName(), this.eventLog});
        ((AtomicInteger)this.getEps().getVariable(AtomicInteger.class, "hardwareFailureJavaCount")).incrementAndGet();
        if (this.eventLog.size() >= 4) {
            ((AtomicInteger)this.getEps().getVariable(AtomicInteger.class, "hardwareFailureJavaFinishCount")).incrementAndGet();
            this.finish();
        }
    }
}

