/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import java.time.Duration;
import org.openksavi.sponge.EngineOperations;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JavaFilter;
import org.openksavi.sponge.java.JavaKnowledgeBase;
import org.openksavi.sponge.java.JavaRule;
import org.openksavi.sponge.java.JavaTrigger;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.test.util.EventsLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKnowledgeBase
extends JavaKnowledgeBase {
    private static final Logger logger = LoggerFactory.getLogger(TestKnowledgeBase.class);
    private EventsLog eventsLog = new EventsLog("e1", "e1e2-first", "e1e2-last", "e1e2-all", "e3");

    public void onInit() {
        logger.debug("onInit");
        this.getEps().setVariable("eventsLog", (Object)this.eventsLog);
    }

    public void onLoad() {
        logger.debug("onLoad");
        this.getEps().enableAll(new Class[]{TestFilter.class, TestTrigger.class, NotToBeRunTrigger.class, TestFirstRule.class, TestLastRule.class, TestAllRule.class});
    }

    public void onStartup() {
        logger.debug("onStartup");
        this.getEps().event("e1").set("mark", (Object)1).sendAfter(100L);
        this.getEps().event("e2").set("mark", (Object)2).sendAfter(200L);
        this.getEps().event("e1").set("mark", (Object)3).sendAfter(300L);
        this.getEps().event("e2").set("mark", (Object)4).sendAfter(400L);
        this.getEps().event("e2").set("mark", (Object)5).sendAfter(500L);
        this.getEps().event("e2").set("mark", (Object)6).sendAfter(600L);
        this.getEps().event("e3").sendAfter(1000L, 100L);
    }

    public void onClear() {
        logger.debug("onClear");
    }

    public void onShutdown() {
        logger.debug("onShutdown");
    }

    public static class TestAllRule
    extends JavaRule {
        public void onConfigure() {
            this.setEvents(new Object[]{this.makeEventSpec("e1"), this.makeEventSpec("e2", EventMode.ALL)});
            this.setDuration(Duration.ofSeconds(2L));
        }

        public void onRun(Event event) {
            this.getLogger().debug("{}-RUN: initial event={}; second event={}", new Object[]{((Object)((Object)this)).hashCode(), this.getEvent("e1"), event});
            EventsLog.getInstance((EngineOperations)this.getEps()).addEvent("e1e2-all", event);
        }
    }

    public static class TestFirstRule
    extends JavaRule {
        public void onConfigure() {
            this.setEvents(new Object[]{this.makeEventSpec("e1"), this.makeEventSpec("e2", EventMode.FIRST)});
            this.setDuration(Duration.ofSeconds(2L));
        }

        public void onRun(Event event) {
            this.getLogger().debug("{}-RUN: initial event={}; second event={}", new Object[]{((Object)((Object)this)).hashCode(), this.getEvent("e1"), event});
            EventsLog.getInstance((EngineOperations)this.getEps()).addEvent("e1e2-first", event);
        }
    }

    public static class TestLastRule
    extends JavaRule {
        public void onConfigure() {
            this.setEvents(new Object[]{this.makeEventSpec("e1"), this.makeEventSpec("e2", EventMode.LAST)});
            this.setConditions("e2", new Object[]{"e2condition"});
            this.setDuration(Duration.ofSeconds(2L));
        }

        public boolean e2condition(Event event) {
            return true;
        }

        public void onRun(Event event) {
            this.getLogger().debug("{}-RUN: initial event={}; second event={}", new Object[]{((Object)((Object)this)).hashCode(), this.getEvent("e1"), event});
            EventsLog.getInstance((EngineOperations)this.getEps()).addEvent("e1e2-last", event);
        }
    }

    public static class TestTrigger
    extends JavaTrigger {
        public void onConfigure() {
            this.setEventName("e1");
        }

        public void onRun(Event event) {
            this.getLogger().debug("Run");
            EventsLog.getInstance((EngineOperations)this.getEps()).addEvent("e1", event);
        }
    }

    public static class NotToBeRunTrigger
    extends JavaTrigger {
        public void onConfigure() {
            this.setEventName("e3");
        }

        public void onRun(Event event) {
            EventsLog.getInstance((EngineOperations)this.getEps()).addEvent("e3", event);
            throw new SpongeException("Should not be fired!");
        }
    }

    public static class TestFilter
    extends JavaFilter {
        public void onConfigure() {
            this.setEvents(new String[]{"e3"});
        }

        public boolean onAccept(Event event) {
            return false;
        }
    }
}

