/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.engine.DefaultEngine;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.CorrelationEventsLog;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesTestTemplate {
    private static final Logger logger = LoggerFactory.getLogger(RulesTestTemplate.class);

    public static void testRules(KnowledgeBaseType type) {
        RulesTestTemplate.testRules(type, ScriptTestUtils.startWithKnowledgeBase(type, "rules"));
    }

    public static void testRules(KnowledgeBaseType type, Engine engine) {
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("hardwareFailureScriptCount")).intValue() >= 3);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("sameSourceFirstFireCount")).intValue() >= 1);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("hardwareFailureJavaCount")).intValue() >= 2);
            Assert.assertEquals((long)3L, (long)((Number)engine.getOperations().getVariable("hardwareFailureScriptCount")).intValue());
            Assert.assertEquals((long)1L, (long)((Number)engine.getOperations().getVariable("sameSourceFirstFireCount")).intValue());
            Assert.assertEquals((long)3L, (long)((Number)engine.getOperations().getVariable("hardwareFailureJavaCount")).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesEvents(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_events");
        try {
            RulesTestTemplate.doTestRulesEvents(type, engine, 180L);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void doTestRulesEvents(KnowledgeBaseType type, Engine engine, long timeout) {
        CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
        LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
        expected.put("RuleF", new String[][]{{"1"}});
        expected.put("RuleFFF", new String[][]{{"1", "2", "5"}});
        expected.put("RuleFFFDuration", new String[][]{{"1", "2", "5"}});
        expected.put("RuleFFL", new String[][]{{"1", "2", "7"}});
        expected.put("RuleFFA", new String[][]{{"1", "2", "5"}, {"1", "2", "6"}, {"1", "2", "7"}});
        expected.put("RuleFFN", new String[][]{{"1", "2", null}});
        expected.put("RuleFLF", new String[][]{{"1", "4", "5"}});
        expected.put("RuleFLL", new String[][]{{"1", "4", "7"}});
        expected.put("RuleFLA", new String[][]{{"1", "4", "5"}, {"1", "4", "6"}, {"1", "4", "7"}});
        expected.put("RuleFLN", new String[][]{{"1", "4", null}});
        expected.put("RuleFAF", new String[][]{{"1", "2", "5"}, {"1", "3", "5"}, {"1", "4", "5"}});
        expected.put("RuleFAL", new String[][]{{"1", "2", "7"}, {"1", "3", "7"}, {"1", "4", "7"}});
        expected.put("RuleFAA", new String[][]{{"1", "2", "5"}, {"1", "3", "5"}, {"1", "4", "5"}, {"1", "2", "6"}, {"1", "3", "6"}, {"1", "4", "6"}, {"1", "2", "7"}, {"1", "3", "7"}, {"1", "4", "7"}});
        expected.put("RuleFNF", new String[][]{{"1", null, "5"}});
        expected.put("RuleFNFReject", new String[0][]);
        expected.put("RuleFNL", new String[][]{{"1", null, "7"}});
        expected.put("RuleFNA", new String[][]{{"1", null, "5"}, {"1", null, "6"}, {"1", null, "7"}});
        expected.put("RuleFAN", new String[][]{{"1", "2", null}, {"1", "3", null}, {"1", "4", null}});
        expected.forEach((rule, sequences) -> {
            try {
                Awaitility.await().atMost(timeout, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
            }
            catch (Exception e) {
                logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                throw e;
            }
        });
        expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
        Assert.assertFalse((boolean)engine.isError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRulesNoneModeEvents(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_none_mode_events");
        try {
            CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
            LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
            expected.put("RuleFNNF", new String[][]{{"1", null, null, "5"}});
            expected.put("RuleFNNNL", new String[][]{{"1", null, null, null, "7"}});
            expected.put("RuleFNNNLReject", new String[0][]);
            expected.put("RuleFNFNL", new String[][]{{"1", null, "2", null, "7"}});
            expected.forEach((rule, sequences) -> {
                try {
                    Awaitility.await().atMost(180L, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
                }
                catch (Exception e) {
                    logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                    throw e;
                }
            });
            expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRulesNoneModeEventsConditions(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_none_mode_events_conditions");
        try {
            CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
            LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
            expected.put("RuleFNF", new String[][]{{"1", null, "5"}});
            expected.put("RuleFNNFReject", new String[0][]);
            expected.forEach((rule, sequences) -> {
                try {
                    Awaitility.await().atMost(180L, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
                }
                catch (Exception e) {
                    logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                    throw e;
                }
            });
            expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesSyncAsync(KnowledgeBaseType type) {
        RulesTestTemplate.testRulesSyncAsync(type, ScriptTestUtils.startWithKnowledgeBase(type, "rules_sync_async"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRulesSyncAsync(KnowledgeBaseType type, Engine engine) {
        try {
            CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
            LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
            expected.put("RuleFFF", new String[][]{{"1", "2", "5"}});
            expected.put("RuleFFL", new String[][]{{"1", "2", "7"}});
            expected.forEach((rule, sequences) -> {
                try {
                    Awaitility.await().atMost(180L, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
                }
                catch (Exception e) {
                    logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                    throw e;
                }
            });
            expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testHeartbeat(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_heartbeat");
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("soundTheAlarm")).get());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testHeartbeat2(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_heartbeat2");
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("soundTheAlarm")).get());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesInstances(KnowledgeBaseType type) {
        BaseEngine engine = DefaultEngine.builder().knowledgeBase("kb", type, new String[]{ScriptTestUtils.getScriptKnowledgeBaseFileName(type, "rules_instances")}).build();
        engine.getDefaultParameters().setAsyncEventSetProcessorProcessingPartitionSize(10);
        engine.startup();
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> RulesTestTemplate.lambda$testRulesInstances$17((Engine)engine));
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> RulesTestTemplate.lambda$testRulesInstances$18((Engine)engine));
            Assert.assertEquals((long)(((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1), (long)((Number)engine.getOperations().getVariable(Number.class, "countA")).intValue());
            Assert.assertEquals((long)(((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1), (long)((Number)engine.getOperations().getVariable(Number.class, "countB")).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    private static /* synthetic */ Boolean lambda$testRulesInstances$18(Engine engine) throws Exception {
        return ((Number)engine.getOperations().getVariable(Number.class, "countB")).intValue() >= ((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1;
    }

    private static /* synthetic */ Boolean lambda$testRulesInstances$17(Engine engine) throws Exception {
        return ((Number)engine.getOperations().getVariable(Number.class, "countA")).intValue() >= ((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1;
    }
}

