/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JavaRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameSourceJavaUnorderedRule
extends JavaRule {
    private static final Logger logger = LoggerFactory.getLogger(SameSourceJavaUnorderedRule.class);

    public void onConfigure() {
        this.setEvents(new String[]{"filesystemFailure e1", "diskFailure e2 :all"});
        this.setOrdered(false);
        this.addConditions("e1", new Object[]{"severityCondition"});
        this.addConditions("e2", new Object[]{"severityCondition", (rule, event) -> event.get("source").equals(rule.getFirstEvent().get("source")) && Duration.between(rule.getFirstEvent().getTime(), event.getTime()).getSeconds() <= 4L});
        this.setDuration(Duration.ofSeconds(5L));
    }

    public void onRun(Event event) {
        logger.info("Monitoring log [{}]: Critical failure in {}! Events: {}", new Object[]{event.getTime(), event.get("source"), this.getEventSequence()});
        ((AtomicInteger)this.getEps().getVariable(AtomicInteger.class, "hardwareFailureJavaCount")).incrementAndGet();
    }

    public boolean severityCondition(Event event) {
        return ((Number)event.get("severity", Number.class)).intValue() > 5;
    }
}

