/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.engine.DefaultEngine;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestStatus;
import org.openksavi.sponge.test.util.TestUtils;

public class KnowledgeBaseTestTemplate {
    public static void testCallbacks(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "knowledge_base_callbacks");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onInitCalled")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onStartupCalled")).get());
            Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onBeforeReloadCalled")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onAfterReloadCalled")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "onLoadCalled")).intValue() == 2);
            TestStatus.onShutdownCalled = false;
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
        Assert.assertTrue((boolean)TestStatus.onShutdownCalled);
    }

    public static void testLoad(KnowledgeBaseType type) {
        BaseEngine engine = DefaultEngine.builder().knowledgeBase("kb", new String[]{ScriptTestUtils.getScriptKnowledgeBaseFileName(type, "knowledge_base_load")}).build();
        engine.getConfigurationManager().setAutoEnable(false);
        engine.startup();
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> KnowledgeBaseTestTemplate.lambda$testLoad$5((Engine)engine));
            Assert.assertTrue((TestUtils.getEventCounter((Engine)engine, "Trigger1, file1") > 1 ? 1 : 0) != 0);
            Assert.assertTrue((TestUtils.getEventCounter((Engine)engine, "Trigger2, file1") > 1 ? 1 : 0) != 0);
            Assert.assertTrue((TestUtils.getEventCounter((Engine)engine, "Trigger1, file2") > 1 ? 1 : 0) != 0);
            Assert.assertTrue((TestUtils.getEventCounter((Engine)engine, "Trigger2, file2") > 1 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)TestUtils.getEventCounter((Engine)engine, "Trigger3, file3"));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testManager(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.buildWithKnowledgeBase(type, "knowledge_base_manager");
        engine.getConfigurationManager().setAutoEnable(false);
        engine.startup();
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "verificationDone")).get());
            Assert.assertTrue((boolean)((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "verifyTriggerEnabled")).get());
            Assert.assertTrue((boolean)((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "verifyTriggerDisabled")).get());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testAutoEnable(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithKnowledgeBase(type, "knowledge_base_auto_enable");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "counter")).intValue() >= 5);
            Assert.assertEquals((long)5L, (long)((Number)engine.getOperations().getVariable(Number.class, "counter")).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    private static String getConcurrencyTestValue(Engine engine) {
        return (String)((AtomicReference)engine.getOperations().getVariable(AtomicReference.class, "value")).get();
    }

    public static void testConcurrency(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "knowledge_base_concurrency");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> "A1".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "B1".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "A2".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "B2".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "C1".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "C2".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testLibrary(KnowledgeBaseType type) {
        Engine engine = ScriptTestUtils.startWithConfig(type, "knowledge_base_library");
        try {
            Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(60L, TimeUnit.SECONDS).until(() -> ((Map)engine.getOperations().getVariable("hostStatus")).size() >= 2);
            Assert.assertEquals((Object)"ERROR", ((Map)engine.getOperations().getVariable("hostStatus")).get("www.wikipedia.org.unknown"));
            Assert.assertEquals((Object)"200", ((Map)engine.getOperations().getVariable("hostStatus")).get("www.wikipedia.org"));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testScriptOverriding(KnowledgeBaseType type) {
        BaseEngine engine = DefaultEngine.builder().config(ScriptTestUtils.getConfigFileName(type, "knowledge_base_script_overriding")).build();
        engine.getConfigurationManager().setAutoEnable(false);
        engine.startup();
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> KnowledgeBaseTestTemplate.lambda$testScriptOverriding$15((Engine)engine));
            Assert.assertEquals((long)0L, (long)((Number)engine.getOperations().getVariable(Number.class, "receivedEventA1")).intValue());
            Assert.assertEquals((long)0L, (long)((Number)engine.getOperations().getVariable(Number.class, "functionA1")).intValue());
            Assert.assertEquals((long)2L, (long)((Number)engine.getOperations().getVariable(Number.class, "functionA2")).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    private static /* synthetic */ Boolean lambda$testScriptOverriding$15(Engine engine) throws Exception {
        return ((Number)engine.getOperations().getVariable(Number.class, "receivedEventA2")).intValue() == 2;
    }

    private static /* synthetic */ Boolean lambda$testLoad$5(Engine engine) throws Exception {
        return TestUtils.getEventCounter(engine, "Trigger1, file3") >= 20;
    }
}

