/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import java.time.Duration;
import org.openksavi.sponge.EngineOperations;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JFilter;
import org.openksavi.sponge.java.JKnowledgeBase;
import org.openksavi.sponge.java.JRule;
import org.openksavi.sponge.java.JTrigger;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.RuleEventSpec;
import org.openksavi.sponge.test.util.EventsLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKnowledgeBase
extends JKnowledgeBase {
    private static final Logger logger = LoggerFactory.getLogger(TestKnowledgeBase.class);
    private EventsLog eventsLog = new EventsLog("e1", "e1e2-first", "e1e2-last", "e1e2-all", "e3");

    public TestKnowledgeBase(String name) {
        super(name);
    }

    public TestKnowledgeBase() {
    }

    public void onInit() {
        logger.debug("onInit");
        this.getSponge().setVariable("eventsLog", (Object)this.eventsLog);
    }

    public void onLoad() {
        logger.debug("onLoad");
    }

    public void onStartup() {
        logger.debug("onStartup");
        this.getSponge().event("e1").set("mark", (Object)1).sendAfter(100L);
        this.getSponge().event("e2").set("mark", (Object)2).sendAfter(200L);
        this.getSponge().event("e1").set("mark", (Object)3).sendAfter(300L);
        this.getSponge().event("e2").set("mark", (Object)4).sendAfter(400L);
        this.getSponge().event("e2").set("mark", (Object)5).sendAfter(500L);
        this.getSponge().event("e2").set("mark", (Object)6).sendAfter(600L);
        this.getSponge().event("e3").sendAfter(1000L, 100L);
    }

    public void onClear() {
        logger.debug("onClear");
    }

    public void onShutdown() {
        logger.debug("onShutdown");
    }

    public static class TestAllRule
    extends JRule {
        public void onConfigure() {
            this.withEventSpecs(new RuleEventSpec[]{this.makeEventSpec("e1"), this.makeEventSpec("e2", EventMode.ALL)});
            this.withDuration(Duration.ofSeconds(2L));
        }

        public void onRun(Event event) {
            this.getLogger().debug("{}-RUN: initial event={}; second event={}", new Object[]{((Object)((Object)this)).hashCode(), this.getEvent("e1"), event});
            EventsLog.getInstance((EngineOperations)this.getSponge()).addEvent("e1e2-all", event);
        }
    }

    public static class TestFirstRule
    extends JRule {
        public void onConfigure() {
            this.withEventSpecs(new RuleEventSpec[]{this.makeEventSpec("e1"), this.makeEventSpec("e2", EventMode.FIRST)});
            this.withDuration(Duration.ofSeconds(2L));
        }

        public void onRun(Event event) {
            this.getLogger().debug("{}-RUN: initial event={}; second event={}", new Object[]{((Object)((Object)this)).hashCode(), this.getEvent("e1"), event});
            EventsLog.getInstance((EngineOperations)this.getSponge()).addEvent("e1e2-first", event);
        }
    }

    public static class TestLastRule
    extends JRule {
        public void onConfigure() {
            this.withEventSpecs(new RuleEventSpec[]{this.makeEventSpec("e1"), this.makeEventSpec("e2", EventMode.LAST)});
            this.withConditions("e2", new String[]{"e2condition"});
            this.withDuration(Duration.ofSeconds(2L));
        }

        public boolean e2condition(Event event) {
            return true;
        }

        public void onRun(Event event) {
            this.getLogger().debug("{}-RUN: initial event={}; second event={}", new Object[]{((Object)((Object)this)).hashCode(), this.getEvent("e1"), event});
            EventsLog.getInstance((EngineOperations)this.getSponge()).addEvent("e1e2-last", event);
        }
    }

    public static class TestTrigger
    extends JTrigger {
        public void onConfigure() {
            this.withEvent("e1");
        }

        public void onRun(Event event) {
            this.getLogger().debug("Run");
            EventsLog.getInstance((EngineOperations)this.getSponge()).addEvent("e1", event);
        }
    }

    public static class NotToBeRunTrigger
    extends JTrigger {
        public void onConfigure() {
            this.withEvent("e3");
        }

        public void onRun(Event event) {
            EventsLog.getInstance((EngineOperations)this.getSponge()).addEvent("e3", event);
            throw new SpongeException("Should not be fired!");
        }
    }

    public static class TestFilter
    extends JFilter {
        public void onConfigure() {
            this.withEvents(new String[]{"e3"});
        }

        public boolean onAccept(Event event) {
            return false;
        }
    }
}

