/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.examples.PowerEchoAction;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.StringType;

public class ActionsTestTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testActions(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("scriptActionResult") != null);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("javaActionResult") != null);
            Object scriptResultObject = engine.getOperations().getVariable("scriptActionResult");
            List scriptResult = scriptResultObject instanceof List ? (List)scriptResultObject : Arrays.stream((Object[])scriptResultObject).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)scriptResult.size());
            Assert.assertEquals((long)1L, (long)((Number)scriptResult.get(0)).intValue());
            Assert.assertEquals((Object)"test", scriptResult.get(1));
            List javaResult = (List)engine.getOperations().getVariable(List.class, "javaActionResult");
            Assert.assertEquals((long)2L, (long)javaResult.size());
            Assert.assertEquals((long)2L, (long)((Number)javaResult.get(0)).intValue());
            Assert.assertEquals((Object)"TEST", javaResult.get(1));
            Assert.assertEquals((long)3L, (long)((Number)engine.getOperations().call(Number.class, "ArrayArgumentAction", Arrays.asList(new Object[]{new Object[]{1, 2, "text"}}))).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testHelloWorldAction(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions_hello_world");
        try {
            String actionName = "HelloWorldAction";
            ActionMeta actionMeta = engine.getActionMeta(actionName);
            Assert.assertEquals((Object)actionName, (Object)actionMeta.getName());
            Assert.assertEquals((Object)"Hello world", (Object)actionMeta.getLabel());
            Assert.assertEquals((Object)"Returns a greeting text.", (Object)actionMeta.getDescription());
            Assert.assertEquals((long)1L, (long)actionMeta.getArgs().size());
            Assert.assertTrue((boolean)actionMeta.getFeatures().isEmpty());
            DataType argType = (DataType)actionMeta.getArgs().get(0);
            Assert.assertEquals((Object)"name", (Object)argType.getName());
            Assert.assertEquals((Object)"Your name", (Object)argType.getLabel());
            Assert.assertEquals((Object)"Type your name.", (Object)argType.getDescription());
            Assert.assertTrue((boolean)(argType instanceof StringType));
            Assert.assertEquals((Object)"Greeting", (Object)actionMeta.getResult().getLabel());
            Assert.assertEquals((Object)"The greeting text.", (Object)actionMeta.getResult().getDescription());
            Assert.assertTrue((boolean)(actionMeta.getResult() instanceof StringType));
            String name = "Sponge user";
            Assert.assertEquals((Object)String.format("Hello World! Hello %s!", name), (Object)engine.getOperations().call(actionName, Arrays.asList(name)));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testActionJavaInheritance(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions_java_inheritance");
        try {
            Assert.assertEquals((long)1L, (long)engine.getActions().size());
            List result = (List)engine.getOperations().call(List.class, "ExtendedFromAction", Arrays.asList(1, "Text"));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((long)11L, (long)((Number)result.get(0)).intValue());
            Assert.assertEquals((Object)"text", result.get(1));
            engine.getOperations().enableJava(PowerEchoAction.class);
            Assert.assertEquals((long)2L, (long)engine.getActions().size());
            List result2 = (List)engine.getOperations().call(List.class, "PowerEchoAction", Arrays.asList(1, "Text"));
            Assert.assertEquals((long)2L, (long)result2.size());
            Assert.assertEquals((long)2L, (long)((Number)result2.get(0)).intValue());
            Assert.assertEquals((Object)"TEXT", result2.get(1));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

