/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.examples.PowerEchoAction;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.StringType;

public class ActionsTestTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testActions(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("scriptActionResult") != null);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("javaActionResult") != null);
            Object scriptResultObject = engine.getOperations().getVariable("scriptActionResult");
            List scriptResult = scriptResultObject instanceof List ? (List)scriptResultObject : Arrays.stream((Object[])scriptResultObject).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)scriptResult.size());
            Assertions.assertEquals((int)1, (int)((Number)scriptResult.get(0)).intValue());
            Assertions.assertEquals((Object)"test", scriptResult.get(1));
            List javaResult = (List)engine.getOperations().getVariable(List.class, "javaActionResult");
            Assertions.assertEquals((int)2, (int)javaResult.size());
            Assertions.assertEquals((int)2, (int)((Number)javaResult.get(0)).intValue());
            Assertions.assertEquals((Object)"TEST", javaResult.get(1));
            Assertions.assertEquals((int)3, (int)((Number)engine.getOperations().call(Number.class, "ArrayArgumentAction", Arrays.asList(new Object[]{new Object[]{1, 2, "text"}}))).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testHelloWorldAction(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions_hello_world");
        try {
            String actionName = "HelloWorldAction";
            ActionMeta actionMeta = engine.getActionMeta(actionName);
            Assertions.assertEquals((Object)actionName, (Object)actionMeta.getName());
            Assertions.assertEquals((Object)"Hello world", (Object)actionMeta.getLabel());
            Assertions.assertEquals((Object)"Returns a greeting text.", (Object)actionMeta.getDescription());
            Assertions.assertEquals((int)1, (int)actionMeta.getArgs().size());
            Assertions.assertTrue((boolean)actionMeta.getFeatures().isEmpty());
            DataType argType = (DataType)actionMeta.getArgs().get(0);
            Assertions.assertEquals((Object)"name", (Object)argType.getName());
            Assertions.assertEquals((Object)"Your name", (Object)argType.getLabel());
            Assertions.assertEquals((Object)"Type your name.", (Object)argType.getDescription());
            Assertions.assertTrue((boolean)(argType instanceof StringType));
            Assertions.assertEquals((Object)"Greeting", (Object)actionMeta.getResult().getLabel());
            Assertions.assertEquals((Object)"The greeting text.", (Object)actionMeta.getResult().getDescription());
            Assertions.assertTrue((boolean)(actionMeta.getResult() instanceof StringType));
            String name = "Sponge user";
            Assertions.assertEquals((Object)String.format("Hello World! Hello %s!", name), (Object)engine.getOperations().call(actionName, Arrays.asList(name)));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testActionJavaInheritance(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions_java_inheritance");
        try {
            Assertions.assertEquals((int)1, (int)engine.getActions().size());
            List result = (List)engine.getOperations().call(List.class, "ExtendedFromAction", Arrays.asList(1, "Text"));
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((int)11, (int)((Number)result.get(0)).intValue());
            Assertions.assertEquals((Object)"text", result.get(1));
            engine.getOperations().enableJava(PowerEchoAction.class);
            Assertions.assertEquals((int)2, (int)engine.getActions().size());
            List result2 = (List)engine.getOperations().call(List.class, "PowerEchoAction", Arrays.asList(1, "Text"));
            Assertions.assertEquals((int)2, (int)result2.size());
            Assertions.assertEquals((int)2, (int)((Number)result2.get(0)).intValue());
            Assertions.assertEquals((Object)"TEXT", result2.get(1));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

