/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;

public class CorrelatorsTestTemplate {
    public static void testCorrelators(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "correlators");
        try {
            Assertions.assertEquals((int)2, (int)engine.getCorrelatorGroups().size());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptFinishCount")).intValue() >= 1 && ((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureJavaFinishCount")).intValue() >= 1);
            Assertions.assertEquals((int)4, (int)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptCount")).intValue());
            Assertions.assertEquals((int)4, (int)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureJavaCount")).intValue());
            Assertions.assertEquals((int)1, (int)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptFinishCount")).intValue());
            Assertions.assertEquals((int)1, (int)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureJavaFinishCount")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testCorrelatorsRepeated(KnowledgeBaseType type) {
        CorrelatorsTestTemplate.testCorrelators(type);
    }

    public static void testCorrelatorsDuration(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "correlators_duration");
        try {
            Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptCount")).intValue() >= 3);
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

