/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestUtils;

public class FiltersTestTemplate {
    public static void testJavaFilter(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters_java");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "e2") >= 5 && TestUtils.getEventCounter(engine, "e3") >= 5);
            TimeUnit.SECONDS.sleep(1L);
            Assertions.assertEquals((int)0, (int)TestUtils.getEventCounter(engine, "e1"));
            Assertions.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testFilter(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "blue") >= 1);
            TimeUnit.SECONDS.sleep(1L);
            Assertions.assertEquals((int)0, (int)TestUtils.getEventCounter(engine, "red"));
            Assertions.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testDeduplication(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters_deduplication");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "e1-red") >= 1 && TestUtils.getEventCounter(engine, "e1-blue") >= 1 && TestUtils.getEventCounter(engine, "e2-red") >= 2 && TestUtils.getEventCounter(engine, "e2-blue") >= 2);
            Assertions.assertEquals((int)1, (int)TestUtils.getEventCounter(engine, "e1-red"));
            Assertions.assertEquals((int)1, (int)TestUtils.getEventCounter(engine, "e1-blue"));
            Assertions.assertEquals((int)2, (int)TestUtils.getEventCounter(engine, "e2-red"));
            Assertions.assertEquals((int)2, (int)TestUtils.getEventCounter(engine, "e2-blue"));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

