/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;

public class PluginsTestTemplate {
    public static void testJavaPlugin(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "plugins_java");
        try {
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("connectionName") != null);
            Assertions.assertEquals((Object)"Example connection", (Object)engine.getOperations().getVariable("connectionName"));
            Assertions.assertEquals((Object)"Echo test! x 2", (Object)engine.getOperations().getVariable("echoConfig"));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testKbPlugin(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "plugins_kb");
        try {
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("valueAfter") != null);
            Assertions.assertEquals((Object)"Value A", (Object)engine.getOperations().getVariable("valueBefore"));
            Assertions.assertEquals((Object)"Value B", (Object)engine.getOperations().getVariable("valueAfter"));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

