/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.CorrelationEventsLog;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesTestTemplate {
    private static final Logger logger = LoggerFactory.getLogger(RulesTestTemplate.class);

    public static void testRules(KnowledgeBaseType type) {
        RulesTestTemplate.testRules(type, ScriptTestUtils.startWithKnowledgeBase(type, "rules"));
    }

    public static void testRules(KnowledgeBaseType type, SpongeEngine engine) {
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("hardwareFailureScriptCount")).intValue() >= 3);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("sameSourceFirstFireCount")).intValue() >= 1);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("hardwareFailureJavaCount")).intValue() >= 2);
            Assertions.assertEquals((int)3, (int)((Number)engine.getOperations().getVariable("hardwareFailureScriptCount")).intValue());
            Assertions.assertEquals((int)1, (int)((Number)engine.getOperations().getVariable("sameSourceFirstFireCount")).intValue());
            Assertions.assertEquals((int)3, (int)((Number)engine.getOperations().getVariable("hardwareFailureJavaCount")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesEvents(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_events");
        try {
            RulesTestTemplate.doTestRulesEvents(type, engine, 180L);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void doTestRulesEvents(KnowledgeBaseType type, SpongeEngine engine, long timeout) {
        LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
        expected.put("RuleF", new String[][]{{"1"}});
        expected.put("RuleFFF", new String[][]{{"1", "2", "5"}});
        expected.put("RuleFFFDuration", new String[][]{{"1", "2", "5"}});
        expected.put("RuleFFL", new String[][]{{"1", "2", "7"}});
        expected.put("RuleFFA", new String[][]{{"1", "2", "5"}, {"1", "2", "6"}, {"1", "2", "7"}});
        expected.put("RuleFFN", new String[][]{{"1", "2", null}});
        expected.put("RuleFLF", new String[][]{{"1", "4", "5"}});
        expected.put("RuleFLL", new String[][]{{"1", "4", "7"}});
        expected.put("RuleFLA", new String[][]{{"1", "4", "5"}, {"1", "4", "6"}, {"1", "4", "7"}});
        expected.put("RuleFLN", new String[][]{{"1", "4", null}});
        expected.put("RuleFAF", new String[][]{{"1", "2", "5"}, {"1", "3", "5"}, {"1", "4", "5"}});
        expected.put("RuleFAL", new String[][]{{"1", "2", "7"}, {"1", "3", "7"}, {"1", "4", "7"}});
        expected.put("RuleFAA", new String[][]{{"1", "2", "5"}, {"1", "3", "5"}, {"1", "4", "5"}, {"1", "2", "6"}, {"1", "3", "6"}, {"1", "4", "6"}, {"1", "2", "7"}, {"1", "3", "7"}, {"1", "4", "7"}});
        expected.put("RuleFNF", new String[][]{{"1", null, "5"}});
        expected.put("RuleFNFReject", new String[0][]);
        expected.put("RuleFNL", new String[][]{{"1", null, "7"}});
        expected.put("RuleFNA", new String[][]{{"1", null, "5"}, {"1", null, "6"}, {"1", null, "7"}});
        expected.put("RuleFAN", new String[][]{{"1", "2", null}, {"1", "3", null}, {"1", "4", null}});
        try {
            TimeUnit.SECONDS.sleep(20L);
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
        expected.forEach((rule, sequences) -> {
            try {
                Awaitility.await().atMost(timeout, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
            }
            catch (Exception e) {
                logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                throw e;
            }
        });
        expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
        Assertions.assertFalse((boolean)engine.isError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRulesNoneModeEvents(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_none_mode_events");
        try {
            CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
            LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
            expected.put("RuleFNNF", new String[][]{{"1", null, null, "5"}});
            expected.put("RuleFNNNL", new String[][]{{"1", null, null, null, "7"}});
            expected.put("RuleFNNNLReject", new String[0][]);
            expected.put("RuleFNFNL", new String[][]{{"1", null, "2", null, "7"}});
            expected.forEach((rule, sequences) -> {
                try {
                    Awaitility.await().atMost(180L, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
                }
                catch (Exception e) {
                    logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                    throw e;
                }
            });
            expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRulesNoneModeEventsConditions(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_none_mode_events_conditions");
        try {
            CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
            LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
            expected.put("RuleFNF", new String[][]{{"1", null, "5"}});
            expected.put("RuleFNNFReject", new String[0][]);
            expected.forEach((rule, sequences) -> {
                try {
                    Awaitility.await().atMost(180L, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
                }
                catch (Exception e) {
                    logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                    throw e;
                }
            });
            expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesSyncAsync(KnowledgeBaseType type) {
        RulesTestTemplate.testRulesSyncAsync(type, ScriptTestUtils.startWithKnowledgeBase(type, "rules_sync_async"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRulesSyncAsync(KnowledgeBaseType type, SpongeEngine engine) {
        try {
            CorrelationEventsLog eventsLog = (CorrelationEventsLog)engine.getOperations().getVariable(CorrelationEventsLog.class, "correlationEventsLog");
            LinkedHashMap<String, String[][]> expected = new LinkedHashMap<String, String[][]>();
            expected.put("RuleFFF", new String[][]{{"1", "2", "5"}});
            expected.put("RuleFFL", new String[][]{{"1", "2", "7"}});
            expected.forEach((rule, sequences) -> {
                try {
                    Awaitility.await().atMost(180L, TimeUnit.SECONDS).until(() -> eventsLog.getEvents((String)rule, "1").size() >= ((String[][])sequences).length);
                }
                catch (Exception e) {
                    logger.error("Unsuccessful waiting for rule {} sequences {}", rule, sequences);
                    throw e;
                }
            });
            expected.forEach((rule, sequences) -> TestUtils.assertEventSequences(eventsLog, rule, "1", sequences));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testHeartbeat(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_heartbeat");
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("soundTheAlarm")).get());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testHeartbeat2(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_heartbeat2");
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("soundTheAlarm")).get());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesInstances(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.buildWithKnowledgeBase(type, "rules_instances");
        engine.getDefaultParameters().setAsyncEventSetProcessorProcessingPartitionSize(10);
        engine.startup();
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "countA")).intValue() >= ((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "countB")).intValue() >= ((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1);
            Assertions.assertEquals((int)(((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1), (int)((Number)engine.getOperations().getVariable(Number.class, "countA")).intValue());
            Assertions.assertEquals((int)(((Number)engine.getOperations().getVariable(Number.class, "max")).intValue() - 1), (int)((Number)engine.getOperations().getVariable(Number.class, "countB")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRulesBuilder(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "rules_builder");
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("hardwareFailureScriptCount")).intValue() >= 3);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable("sameSourceFirstFireCount")).intValue() >= 1);
            Assertions.assertEquals((int)3, (int)((Number)engine.getOperations().getVariable("hardwareFailureScriptCount")).intValue());
            Assertions.assertEquals((int)1, (int)((Number)engine.getOperations().getVariable("sameSourceFirstFireCount")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

