/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.test.util.CorrelationEventsLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SocketUtils;

public class TestUtils {
    private static final Logger logger = LoggerFactory.getLogger(TestUtils.class);
    public static final String DEFAULT_KB = "kb";

    public static List<Event> getEvents(SpongeEngine engine, String eventName) {
        Map events = (Map)engine.getOperations().getVariable(Map.class, "events");
        return (List)events.get(eventName);
    }

    public static int getEventCounter(SpongeEngine engine, String key) {
        return ((Number)((Map)engine.getOperations().getVariable("eventCounter")).get(key)).intValue();
    }

    public static void assertEventSequences(CorrelationEventsLog eventsLog, String key, String firstEventLabel, String[][] expected) {
        TestUtils.assertEventSequences(eventsLog, key, firstEventLabel, expected, false);
    }

    public static void assertEventSequences(CorrelationEventsLog eventsLog, String key, String firstEventLabel, String[][] expected, boolean ignoreOrderOfSequences) {
        List<List<Event>> lists = eventsLog.getEvents(key, firstEventLabel);
        Assertions.assertEquals((int)expected.length, (int)lists.size());
        Collection<Object> expectedSequenceReport = null;
        SequencedCollection<Object> realSequenceReport = null;
        try {
            if (ignoreOrderOfSequences) {
                Set expectedSet = Stream.of(expected).map(sequence -> Arrays.asList(sequence)).collect(Collectors.toCollection(LinkedHashSet::new));
                LinkedHashSet realSet = new LinkedHashSet();
                lists.forEach(list -> realSet.add(list.stream().map(event -> event != null ? (String)event.get(String.class, "label") : null).collect(Collectors.toCollection(ArrayList::new))));
                expectedSequenceReport = expectedSet;
                realSequenceReport = realSet;
                Assertions.assertEquals((Object)expectedSet, realSet);
            } else {
                for (int i = 0; i < expected.length; ++i) {
                    Object[] expectedSequence = expected[i];
                    Object[] realSequence = (String[])lists.get(i).stream().map(event -> event != null ? (String)event.get(String.class, "label") : null).toArray(String[]::new);
                    expectedSequenceReport = Arrays.asList(expectedSequence);
                    realSequenceReport = Arrays.asList(realSequence);
                    Assertions.assertArrayEquals((Object[])expectedSequence, (Object[])realSequence);
                }
            }
        }
        catch (AssertionError e) {
            logger.error("ERROR key=" + key + ", expcted=" + expectedSequenceReport + ", real=" + realSequenceReport, (Throwable)((Object)e));
            throw e;
        }
    }

    public static int findAvailablePairOfNeighbouringTcpPorts() {
        return TestUtils.findAvailablePairOfNeighbouringTcpPorts(20000, 60000, 1000);
    }

    public static int findAvailablePairOfNeighbouringTcpPorts(int minPort, int maxPort, int maxAttempts) {
        for (int i = 0; i < maxAttempts; ++i) {
            int basePort = SocketUtils.findAvailableTcpPort((int)minPort, (int)maxPort);
            int neighbourPort = -1;
            try {
                neighbourPort = SocketUtils.findAvailableTcpPort((int)(basePort + 1), (int)(basePort + 1));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (neighbourPort != basePort + 1) continue;
            return basePort;
        }
        throw new IllegalStateException("No two available neighbouring ports found");
    }
}

